<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailAddressRecord StructType
 * @subpackage Structs
 */
class EmailAddressRecord extends DataRecord
{
    /**
     * The EmailType_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EmailType_Id;
    /**
     * The ReceiveEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ReceiveEmail;
    /**
     * The IsPreferredEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsPreferredEmail;
    /**
     * The LastEmailDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastEmailDate;
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Contact_Id;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * Constructor method for EmailAddressRecord
     * @uses EmailAddressRecord::setEmailType_Id()
     * @uses EmailAddressRecord::setReceiveEmail()
     * @uses EmailAddressRecord::setIsPreferredEmail()
     * @uses EmailAddressRecord::setLastEmailDate()
     * @uses EmailAddressRecord::setContact_Id()
     * @uses EmailAddressRecord::setActive()
     * @uses EmailAddressRecord::setEmail()
     * @param int $emailType_Id
     * @param bool $receiveEmail
     * @param bool $isPreferredEmail
     * @param string $lastEmailDate
     * @param int $contact_Id
     * @param bool $active
     * @param string $email
     */
    public function __construct($emailType_Id = null, $receiveEmail = null, $isPreferredEmail = null, $lastEmailDate = null, $contact_Id = null, $active = null, $email = null)
    {
        $this
            ->setEmailType_Id($emailType_Id)
            ->setReceiveEmail($receiveEmail)
            ->setIsPreferredEmail($isPreferredEmail)
            ->setLastEmailDate($lastEmailDate)
            ->setContact_Id($contact_Id)
            ->setActive($active)
            ->setEmail($email);
    }
    /**
     * Get EmailType_Id value
     * @return int
     */
    public function getEmailType_Id()
    {
        return $this->EmailType_Id;
    }
    /**
     * Set EmailType_Id value
     * @param int $emailType_Id
     * @return \StructType\EmailAddressRecord
     */
    public function setEmailType_Id($emailType_Id = null)
    {
        // validation for constraint: int
        if (!is_null($emailType_Id) && !is_numeric($emailType_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($emailType_Id)), __LINE__);
        }
        $this->EmailType_Id = $emailType_Id;
        return $this;
    }
    /**
     * Get ReceiveEmail value
     * @return bool
     */
    public function getReceiveEmail()
    {
        return $this->ReceiveEmail;
    }
    /**
     * Set ReceiveEmail value
     * @param bool $receiveEmail
     * @return \StructType\EmailAddressRecord
     */
    public function setReceiveEmail($receiveEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($receiveEmail) && !is_bool($receiveEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($receiveEmail)), __LINE__);
        }
        $this->ReceiveEmail = $receiveEmail;
        return $this;
    }
    /**
     * Get IsPreferredEmail value
     * @return bool
     */
    public function getIsPreferredEmail()
    {
        return $this->IsPreferredEmail;
    }
    /**
     * Set IsPreferredEmail value
     * @param bool $isPreferredEmail
     * @return \StructType\EmailAddressRecord
     */
    public function setIsPreferredEmail($isPreferredEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPreferredEmail) && !is_bool($isPreferredEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPreferredEmail)), __LINE__);
        }
        $this->IsPreferredEmail = $isPreferredEmail;
        return $this;
    }
    /**
     * Get LastEmailDate value
     * @return string
     */
    public function getLastEmailDate()
    {
        return $this->LastEmailDate;
    }
    /**
     * Set LastEmailDate value
     * @param string $lastEmailDate
     * @return \StructType\EmailAddressRecord
     */
    public function setLastEmailDate($lastEmailDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastEmailDate) && !is_string($lastEmailDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastEmailDate)), __LINE__);
        }
        $this->LastEmailDate = $lastEmailDate;
        return $this;
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\EmailAddressRecord
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\EmailAddressRecord
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\EmailAddressRecord
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmailAddressRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
