<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditSustainerParameters StructType
 * @subpackage Structs
 */
class EditSustainerParameters extends EditRecordParameters
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The TaxDeductibleAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxDeductibleAmount;
    /**
     * The Limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Limit;
    /**
     * The Frequency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Frequency;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The PauseUntil
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PauseUntil;
    /**
     * The ResetBilingDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ResetBilingDate;
    /**
     * The TerminationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TerminationDate;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentMode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PaymentMode;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateSustainerTypeParameters
     */
    public $Type;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateSustainerStatusParameters
     */
    public $Status;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateTransactionCategoryParameters
     */
    public $Category;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $Contact;
    /**
     * The TerminationReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateSustainerTerminationReasonParameters
     */
    public $TerminationReason;
    /**
     * The CreditCardInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CreditCardParameters
     */
    public $CreditCardInfo;
    /**
     * The BankAccountInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BankAccountParameters
     */
    public $BankAccountInfo;
    /**
     * The PaymentBillingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentBillingContactParameters
     */
    public $PaymentBillingInfo;
    /**
     * The Attribution
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SustainerAttributionParameters
     */
    public $Attribution;
    /**
     * The PrivacyPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentPrivacyPreferenceParameters
     */
    public $PrivacyPreferences;
    /**
     * The UpdateContactActions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactUpdateActionParameters
     */
    public $UpdateContactActions;
    /**
     * Constructor method for EditSustainerParameters
     * @uses EditSustainerParameters::setActive()
     * @uses EditSustainerParameters::setAmount()
     * @uses EditSustainerParameters::setTaxDeductibleAmount()
     * @uses EditSustainerParameters::setLimit()
     * @uses EditSustainerParameters::setFrequency()
     * @uses EditSustainerParameters::setStartDate()
     * @uses EditSustainerParameters::setEndDate()
     * @uses EditSustainerParameters::setPauseUntil()
     * @uses EditSustainerParameters::setResetBilingDate()
     * @uses EditSustainerParameters::setTerminationDate()
     * @uses EditSustainerParameters::setPaymentMethod()
     * @uses EditSustainerParameters::setPaymentMode()
     * @uses EditSustainerParameters::setType()
     * @uses EditSustainerParameters::setStatus()
     * @uses EditSustainerParameters::setCategory()
     * @uses EditSustainerParameters::setContact()
     * @uses EditSustainerParameters::setTerminationReason()
     * @uses EditSustainerParameters::setCreditCardInfo()
     * @uses EditSustainerParameters::setBankAccountInfo()
     * @uses EditSustainerParameters::setPaymentBillingInfo()
     * @uses EditSustainerParameters::setAttribution()
     * @uses EditSustainerParameters::setPrivacyPreferences()
     * @uses EditSustainerParameters::setUpdateContactActions()
     * @param bool $active
     * @param float $amount
     * @param float $taxDeductibleAmount
     * @param float $limit
     * @param string $frequency
     * @param string $startDate
     * @param string $endDate
     * @param string $pauseUntil
     * @param string $resetBilingDate
     * @param string $terminationDate
     * @param string $paymentMethod
     * @param string $paymentMode
     * @param \StructType\FindOrCreateSustainerTypeParameters $type
     * @param \StructType\FindOrCreateSustainerStatusParameters $status
     * @param \StructType\FindOrCreateTransactionCategoryParameters $category
     * @param \StructType\FindOrCreateContactParameters $contact
     * @param \StructType\FindOrCreateSustainerTerminationReasonParameters $terminationReason
     * @param \StructType\CreditCardParameters $creditCardInfo
     * @param \StructType\BankAccountParameters $bankAccountInfo
     * @param \StructType\PaymentBillingContactParameters $paymentBillingInfo
     * @param \StructType\SustainerAttributionParameters $attribution
     * @param \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences
     * @param \StructType\ContactUpdateActionParameters $updateContactActions
     */
    public function __construct($active = null, $amount = null, $taxDeductibleAmount = null, $limit = null, $frequency = null, $startDate = null, $endDate = null, $pauseUntil = null, $resetBilingDate = null, $terminationDate = null, $paymentMethod = null, $paymentMode = null, \StructType\FindOrCreateSustainerTypeParameters $type = null, \StructType\FindOrCreateSustainerStatusParameters $status = null, \StructType\FindOrCreateTransactionCategoryParameters $category = null, \StructType\FindOrCreateContactParameters $contact = null, \StructType\FindOrCreateSustainerTerminationReasonParameters $terminationReason = null, \StructType\CreditCardParameters $creditCardInfo = null, \StructType\BankAccountParameters $bankAccountInfo = null, \StructType\PaymentBillingContactParameters $paymentBillingInfo = null, \StructType\SustainerAttributionParameters $attribution = null, \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences = null, \StructType\ContactUpdateActionParameters $updateContactActions = null)
    {
        $this
            ->setActive($active)
            ->setAmount($amount)
            ->setTaxDeductibleAmount($taxDeductibleAmount)
            ->setLimit($limit)
            ->setFrequency($frequency)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setPauseUntil($pauseUntil)
            ->setResetBilingDate($resetBilingDate)
            ->setTerminationDate($terminationDate)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentMode($paymentMode)
            ->setType($type)
            ->setStatus($status)
            ->setCategory($category)
            ->setContact($contact)
            ->setTerminationReason($terminationReason)
            ->setCreditCardInfo($creditCardInfo)
            ->setBankAccountInfo($bankAccountInfo)
            ->setPaymentBillingInfo($paymentBillingInfo)
            ->setAttribution($attribution)
            ->setPrivacyPreferences($privacyPreferences)
            ->setUpdateContactActions($updateContactActions);
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\EditSustainerParameters
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\EditSustainerParameters
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxDeductibleAmount value
     * @return float
     */
    public function getTaxDeductibleAmount()
    {
        return $this->TaxDeductibleAmount;
    }
    /**
     * Set TaxDeductibleAmount value
     * @param float $taxDeductibleAmount
     * @return \StructType\EditSustainerParameters
     */
    public function setTaxDeductibleAmount($taxDeductibleAmount = null)
    {
        $this->TaxDeductibleAmount = $taxDeductibleAmount;
        return $this;
    }
    /**
     * Get Limit value
     * @return float
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param float $limit
     * @return \StructType\EditSustainerParameters
     */
    public function setLimit($limit = null)
    {
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @uses \EnumType\SustainerFrequencies::valueIsValid()
     * @uses \EnumType\SustainerFrequencies::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequency
     * @return \StructType\EditSustainerParameters
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SustainerFrequencies::valueIsValid($frequency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $frequency, implode(', ', \EnumType\SustainerFrequencies::getValidValues())), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\EditSustainerParameters
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\EditSustainerParameters
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get PauseUntil value
     * @return string
     */
    public function getPauseUntil()
    {
        return $this->PauseUntil;
    }
    /**
     * Set PauseUntil value
     * @param string $pauseUntil
     * @return \StructType\EditSustainerParameters
     */
    public function setPauseUntil($pauseUntil = null)
    {
        // validation for constraint: string
        if (!is_null($pauseUntil) && !is_string($pauseUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pauseUntil)), __LINE__);
        }
        $this->PauseUntil = $pauseUntil;
        return $this;
    }
    /**
     * Get ResetBilingDate value
     * @return string
     */
    public function getResetBilingDate()
    {
        return $this->ResetBilingDate;
    }
    /**
     * Set ResetBilingDate value
     * @param string $resetBilingDate
     * @return \StructType\EditSustainerParameters
     */
    public function setResetBilingDate($resetBilingDate = null)
    {
        // validation for constraint: string
        if (!is_null($resetBilingDate) && !is_string($resetBilingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resetBilingDate)), __LINE__);
        }
        $this->ResetBilingDate = $resetBilingDate;
        return $this;
    }
    /**
     * Get TerminationDate value
     * @return string
     */
    public function getTerminationDate()
    {
        return $this->TerminationDate;
    }
    /**
     * Set TerminationDate value
     * @param string $terminationDate
     * @return \StructType\EditSustainerParameters
     */
    public function setTerminationDate($terminationDate = null)
    {
        // validation for constraint: string
        if (!is_null($terminationDate) && !is_string($terminationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminationDate)), __LINE__);
        }
        $this->TerminationDate = $terminationDate;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @uses \EnumType\PaymentMethods::valueIsValid()
     * @uses \EnumType\PaymentMethods::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethod
     * @return \StructType\EditSustainerParameters
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentMethods::valueIsValid($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentMethod, implode(', ', \EnumType\PaymentMethods::getValidValues())), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get PaymentMode value
     * @return string
     */
    public function getPaymentMode()
    {
        return $this->PaymentMode;
    }
    /**
     * Set PaymentMode value
     * @uses \EnumType\EditSustainerPaymentModes::valueIsValid()
     * @uses \EnumType\EditSustainerPaymentModes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMode
     * @return \StructType\EditSustainerParameters
     */
    public function setPaymentMode($paymentMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EditSustainerPaymentModes::valueIsValid($paymentMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentMode, implode(', ', \EnumType\EditSustainerPaymentModes::getValidValues())), __LINE__);
        }
        $this->PaymentMode = $paymentMode;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\FindOrCreateSustainerTypeParameters|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\FindOrCreateSustainerTypeParameters $type
     * @return \StructType\EditSustainerParameters
     */
    public function setType(\StructType\FindOrCreateSustainerTypeParameters $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\FindOrCreateSustainerStatusParameters|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\FindOrCreateSustainerStatusParameters $status
     * @return \StructType\EditSustainerParameters
     */
    public function setStatus(\StructType\FindOrCreateSustainerStatusParameters $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Category value
     * @return \StructType\FindOrCreateTransactionCategoryParameters|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param \StructType\FindOrCreateTransactionCategoryParameters $category
     * @return \StructType\EditSustainerParameters
     */
    public function setCategory(\StructType\FindOrCreateTransactionCategoryParameters $category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\FindOrCreateContactParameters $contact
     * @return \StructType\EditSustainerParameters
     */
    public function setContact(\StructType\FindOrCreateContactParameters $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get TerminationReason value
     * @return \StructType\FindOrCreateSustainerTerminationReasonParameters|null
     */
    public function getTerminationReason()
    {
        return $this->TerminationReason;
    }
    /**
     * Set TerminationReason value
     * @param \StructType\FindOrCreateSustainerTerminationReasonParameters $terminationReason
     * @return \StructType\EditSustainerParameters
     */
    public function setTerminationReason(\StructType\FindOrCreateSustainerTerminationReasonParameters $terminationReason = null)
    {
        $this->TerminationReason = $terminationReason;
        return $this;
    }
    /**
     * Get CreditCardInfo value
     * @return \StructType\CreditCardParameters|null
     */
    public function getCreditCardInfo()
    {
        return $this->CreditCardInfo;
    }
    /**
     * Set CreditCardInfo value
     * @param \StructType\CreditCardParameters $creditCardInfo
     * @return \StructType\EditSustainerParameters
     */
    public function setCreditCardInfo(\StructType\CreditCardParameters $creditCardInfo = null)
    {
        $this->CreditCardInfo = $creditCardInfo;
        return $this;
    }
    /**
     * Get BankAccountInfo value
     * @return \StructType\BankAccountParameters|null
     */
    public function getBankAccountInfo()
    {
        return $this->BankAccountInfo;
    }
    /**
     * Set BankAccountInfo value
     * @param \StructType\BankAccountParameters $bankAccountInfo
     * @return \StructType\EditSustainerParameters
     */
    public function setBankAccountInfo(\StructType\BankAccountParameters $bankAccountInfo = null)
    {
        $this->BankAccountInfo = $bankAccountInfo;
        return $this;
    }
    /**
     * Get PaymentBillingInfo value
     * @return \StructType\PaymentBillingContactParameters|null
     */
    public function getPaymentBillingInfo()
    {
        return $this->PaymentBillingInfo;
    }
    /**
     * Set PaymentBillingInfo value
     * @param \StructType\PaymentBillingContactParameters $paymentBillingInfo
     * @return \StructType\EditSustainerParameters
     */
    public function setPaymentBillingInfo(\StructType\PaymentBillingContactParameters $paymentBillingInfo = null)
    {
        $this->PaymentBillingInfo = $paymentBillingInfo;
        return $this;
    }
    /**
     * Get Attribution value
     * @return \StructType\SustainerAttributionParameters|null
     */
    public function getAttribution()
    {
        return $this->Attribution;
    }
    /**
     * Set Attribution value
     * @param \StructType\SustainerAttributionParameters $attribution
     * @return \StructType\EditSustainerParameters
     */
    public function setAttribution(\StructType\SustainerAttributionParameters $attribution = null)
    {
        $this->Attribution = $attribution;
        return $this;
    }
    /**
     * Get PrivacyPreferences value
     * @return \StructType\PaymentPrivacyPreferenceParameters|null
     */
    public function getPrivacyPreferences()
    {
        return $this->PrivacyPreferences;
    }
    /**
     * Set PrivacyPreferences value
     * @param \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences
     * @return \StructType\EditSustainerParameters
     */
    public function setPrivacyPreferences(\StructType\PaymentPrivacyPreferenceParameters $privacyPreferences = null)
    {
        $this->PrivacyPreferences = $privacyPreferences;
        return $this;
    }
    /**
     * Get UpdateContactActions value
     * @return \StructType\ContactUpdateActionParameters|null
     */
    public function getUpdateContactActions()
    {
        return $this->UpdateContactActions;
    }
    /**
     * Set UpdateContactActions value
     * @param \StructType\ContactUpdateActionParameters $updateContactActions
     * @return \StructType\EditSustainerParameters
     */
    public function setUpdateContactActions(\StructType\ContactUpdateActionParameters $updateContactActions = null)
    {
        $this->UpdateContactActions = $updateContactActions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditSustainerParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
