<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditOrganizationParameters StructType
 * @subpackage Structs
 */
class EditOrganizationParameters extends EditRecordParameters
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The MailOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $MailOptIn;
    /**
     * The EmailOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $EmailOptIn;
    /**
     * The PhoneOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PhoneOptIn;
    /**
     * The FaxOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $FaxOptIn;
    /**
     * The SmsOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SmsOptIn;
    /**
     * The SyncType_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SyncType_Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The PrimaryAddressStreet1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryAddressStreet1;
    /**
     * The PrimaryAddressStreet2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryAddressStreet2;
    /**
     * The PrimaryAddressCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryAddressCity;
    /**
     * The PrimaryAddressState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryAddressState;
    /**
     * The PrimaryAddressPostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryAddressPostalCode;
    /**
     * The PrimaryAddressCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryAddressCountry;
    /**
     * The PrimaryEmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryEmailAddress;
    /**
     * The PrimaryPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryPhone;
    /**
     * The PrimaryFax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryFax;
    /**
     * The PrimarySms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimarySms;
    /**
     * The SyncExternalId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SyncExternalId;
    /**
     * The Groups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfChangeContactGroupParameters
     */
    public $Groups;
    /**
     * The Tags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfChangeContactTagParameters
     */
    public $Tags;
    /**
     * The OptInLists
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfChangeContactOptInListParameters
     */
    public $OptInLists;
    /**
     * The CustomFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEditContactCustomFieldParameters
     */
    public $CustomFields;
    /**
     * Constructor method for EditOrganizationParameters
     * @uses EditOrganizationParameters::setType()
     * @uses EditOrganizationParameters::setMailOptIn()
     * @uses EditOrganizationParameters::setEmailOptIn()
     * @uses EditOrganizationParameters::setPhoneOptIn()
     * @uses EditOrganizationParameters::setFaxOptIn()
     * @uses EditOrganizationParameters::setSmsOptIn()
     * @uses EditOrganizationParameters::setSyncType_Id()
     * @uses EditOrganizationParameters::setName()
     * @uses EditOrganizationParameters::setPrimaryAddressStreet1()
     * @uses EditOrganizationParameters::setPrimaryAddressStreet2()
     * @uses EditOrganizationParameters::setPrimaryAddressCity()
     * @uses EditOrganizationParameters::setPrimaryAddressState()
     * @uses EditOrganizationParameters::setPrimaryAddressPostalCode()
     * @uses EditOrganizationParameters::setPrimaryAddressCountry()
     * @uses EditOrganizationParameters::setPrimaryEmailAddress()
     * @uses EditOrganizationParameters::setPrimaryPhone()
     * @uses EditOrganizationParameters::setPrimaryFax()
     * @uses EditOrganizationParameters::setPrimarySms()
     * @uses EditOrganizationParameters::setSyncExternalId()
     * @uses EditOrganizationParameters::setGroups()
     * @uses EditOrganizationParameters::setTags()
     * @uses EditOrganizationParameters::setOptInLists()
     * @uses EditOrganizationParameters::setCustomFields()
     * @param string $type
     * @param bool $mailOptIn
     * @param bool $emailOptIn
     * @param bool $phoneOptIn
     * @param bool $faxOptIn
     * @param bool $smsOptIn
     * @param int $syncType_Id
     * @param string $name
     * @param string $primaryAddressStreet1
     * @param string $primaryAddressStreet2
     * @param string $primaryAddressCity
     * @param string $primaryAddressState
     * @param string $primaryAddressPostalCode
     * @param string $primaryAddressCountry
     * @param string $primaryEmailAddress
     * @param string $primaryPhone
     * @param string $primaryFax
     * @param string $primarySms
     * @param string $syncExternalId
     * @param \ArrayType\ArrayOfChangeContactGroupParameters $groups
     * @param \ArrayType\ArrayOfChangeContactTagParameters $tags
     * @param \ArrayType\ArrayOfChangeContactOptInListParameters $optInLists
     * @param \ArrayType\ArrayOfEditContactCustomFieldParameters $customFields
     */
    public function __construct($type = null, $mailOptIn = null, $emailOptIn = null, $phoneOptIn = null, $faxOptIn = null, $smsOptIn = null, $syncType_Id = null, $name = null, $primaryAddressStreet1 = null, $primaryAddressStreet2 = null, $primaryAddressCity = null, $primaryAddressState = null, $primaryAddressPostalCode = null, $primaryAddressCountry = null, $primaryEmailAddress = null, $primaryPhone = null, $primaryFax = null, $primarySms = null, $syncExternalId = null, \ArrayType\ArrayOfChangeContactGroupParameters $groups = null, \ArrayType\ArrayOfChangeContactTagParameters $tags = null, \ArrayType\ArrayOfChangeContactOptInListParameters $optInLists = null, \ArrayType\ArrayOfEditContactCustomFieldParameters $customFields = null)
    {
        $this
            ->setType($type)
            ->setMailOptIn($mailOptIn)
            ->setEmailOptIn($emailOptIn)
            ->setPhoneOptIn($phoneOptIn)
            ->setFaxOptIn($faxOptIn)
            ->setSmsOptIn($smsOptIn)
            ->setSyncType_Id($syncType_Id)
            ->setName($name)
            ->setPrimaryAddressStreet1($primaryAddressStreet1)
            ->setPrimaryAddressStreet2($primaryAddressStreet2)
            ->setPrimaryAddressCity($primaryAddressCity)
            ->setPrimaryAddressState($primaryAddressState)
            ->setPrimaryAddressPostalCode($primaryAddressPostalCode)
            ->setPrimaryAddressCountry($primaryAddressCountry)
            ->setPrimaryEmailAddress($primaryEmailAddress)
            ->setPrimaryPhone($primaryPhone)
            ->setPrimaryFax($primaryFax)
            ->setPrimarySms($primarySms)
            ->setSyncExternalId($syncExternalId)
            ->setGroups($groups)
            ->setTags($tags)
            ->setOptInLists($optInLists)
            ->setCustomFields($customFields);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\OrganizationTypes::valueIsValid()
     * @uses \EnumType\OrganizationTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\EditOrganizationParameters
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrganizationTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\OrganizationTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get MailOptIn value
     * @return bool
     */
    public function getMailOptIn()
    {
        return $this->MailOptIn;
    }
    /**
     * Set MailOptIn value
     * @param bool $mailOptIn
     * @return \StructType\EditOrganizationParameters
     */
    public function setMailOptIn($mailOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailOptIn) && !is_bool($mailOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mailOptIn)), __LINE__);
        }
        $this->MailOptIn = $mailOptIn;
        return $this;
    }
    /**
     * Get EmailOptIn value
     * @return bool
     */
    public function getEmailOptIn()
    {
        return $this->EmailOptIn;
    }
    /**
     * Set EmailOptIn value
     * @param bool $emailOptIn
     * @return \StructType\EditOrganizationParameters
     */
    public function setEmailOptIn($emailOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailOptIn) && !is_bool($emailOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($emailOptIn)), __LINE__);
        }
        $this->EmailOptIn = $emailOptIn;
        return $this;
    }
    /**
     * Get PhoneOptIn value
     * @return bool
     */
    public function getPhoneOptIn()
    {
        return $this->PhoneOptIn;
    }
    /**
     * Set PhoneOptIn value
     * @param bool $phoneOptIn
     * @return \StructType\EditOrganizationParameters
     */
    public function setPhoneOptIn($phoneOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneOptIn) && !is_bool($phoneOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($phoneOptIn)), __LINE__);
        }
        $this->PhoneOptIn = $phoneOptIn;
        return $this;
    }
    /**
     * Get FaxOptIn value
     * @return bool
     */
    public function getFaxOptIn()
    {
        return $this->FaxOptIn;
    }
    /**
     * Set FaxOptIn value
     * @param bool $faxOptIn
     * @return \StructType\EditOrganizationParameters
     */
    public function setFaxOptIn($faxOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($faxOptIn) && !is_bool($faxOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($faxOptIn)), __LINE__);
        }
        $this->FaxOptIn = $faxOptIn;
        return $this;
    }
    /**
     * Get SmsOptIn value
     * @return bool
     */
    public function getSmsOptIn()
    {
        return $this->SmsOptIn;
    }
    /**
     * Set SmsOptIn value
     * @param bool $smsOptIn
     * @return \StructType\EditOrganizationParameters
     */
    public function setSmsOptIn($smsOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($smsOptIn) && !is_bool($smsOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smsOptIn)), __LINE__);
        }
        $this->SmsOptIn = $smsOptIn;
        return $this;
    }
    /**
     * Get SyncType_Id value
     * @return int
     */
    public function getSyncType_Id()
    {
        return $this->SyncType_Id;
    }
    /**
     * Set SyncType_Id value
     * @param int $syncType_Id
     * @return \StructType\EditOrganizationParameters
     */
    public function setSyncType_Id($syncType_Id = null)
    {
        // validation for constraint: int
        if (!is_null($syncType_Id) && !is_numeric($syncType_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($syncType_Id)), __LINE__);
        }
        $this->SyncType_Id = $syncType_Id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\EditOrganizationParameters
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PrimaryAddressStreet1 value
     * @return string|null
     */
    public function getPrimaryAddressStreet1()
    {
        return $this->PrimaryAddressStreet1;
    }
    /**
     * Set PrimaryAddressStreet1 value
     * @param string $primaryAddressStreet1
     * @return \StructType\EditOrganizationParameters
     */
    public function setPrimaryAddressStreet1($primaryAddressStreet1 = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAddressStreet1) && !is_string($primaryAddressStreet1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAddressStreet1)), __LINE__);
        }
        $this->PrimaryAddressStreet1 = $primaryAddressStreet1;
        return $this;
    }
    /**
     * Get PrimaryAddressStreet2 value
     * @return string|null
     */
    public function getPrimaryAddressStreet2()
    {
        return $this->PrimaryAddressStreet2;
    }
    /**
     * Set PrimaryAddressStreet2 value
     * @param string $primaryAddressStreet2
     * @return \StructType\EditOrganizationParameters
     */
    public function setPrimaryAddressStreet2($primaryAddressStreet2 = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAddressStreet2) && !is_string($primaryAddressStreet2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAddressStreet2)), __LINE__);
        }
        $this->PrimaryAddressStreet2 = $primaryAddressStreet2;
        return $this;
    }
    /**
     * Get PrimaryAddressCity value
     * @return string|null
     */
    public function getPrimaryAddressCity()
    {
        return $this->PrimaryAddressCity;
    }
    /**
     * Set PrimaryAddressCity value
     * @param string $primaryAddressCity
     * @return \StructType\EditOrganizationParameters
     */
    public function setPrimaryAddressCity($primaryAddressCity = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAddressCity) && !is_string($primaryAddressCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAddressCity)), __LINE__);
        }
        $this->PrimaryAddressCity = $primaryAddressCity;
        return $this;
    }
    /**
     * Get PrimaryAddressState value
     * @return string|null
     */
    public function getPrimaryAddressState()
    {
        return $this->PrimaryAddressState;
    }
    /**
     * Set PrimaryAddressState value
     * @param string $primaryAddressState
     * @return \StructType\EditOrganizationParameters
     */
    public function setPrimaryAddressState($primaryAddressState = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAddressState) && !is_string($primaryAddressState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAddressState)), __LINE__);
        }
        $this->PrimaryAddressState = $primaryAddressState;
        return $this;
    }
    /**
     * Get PrimaryAddressPostalCode value
     * @return string|null
     */
    public function getPrimaryAddressPostalCode()
    {
        return $this->PrimaryAddressPostalCode;
    }
    /**
     * Set PrimaryAddressPostalCode value
     * @param string $primaryAddressPostalCode
     * @return \StructType\EditOrganizationParameters
     */
    public function setPrimaryAddressPostalCode($primaryAddressPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAddressPostalCode) && !is_string($primaryAddressPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAddressPostalCode)), __LINE__);
        }
        $this->PrimaryAddressPostalCode = $primaryAddressPostalCode;
        return $this;
    }
    /**
     * Get PrimaryAddressCountry value
     * @return string|null
     */
    public function getPrimaryAddressCountry()
    {
        return $this->PrimaryAddressCountry;
    }
    /**
     * Set PrimaryAddressCountry value
     * @param string $primaryAddressCountry
     * @return \StructType\EditOrganizationParameters
     */
    public function setPrimaryAddressCountry($primaryAddressCountry = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAddressCountry) && !is_string($primaryAddressCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAddressCountry)), __LINE__);
        }
        $this->PrimaryAddressCountry = $primaryAddressCountry;
        return $this;
    }
    /**
     * Get PrimaryEmailAddress value
     * @return string|null
     */
    public function getPrimaryEmailAddress()
    {
        return $this->PrimaryEmailAddress;
    }
    /**
     * Set PrimaryEmailAddress value
     * @param string $primaryEmailAddress
     * @return \StructType\EditOrganizationParameters
     */
    public function setPrimaryEmailAddress($primaryEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryEmailAddress) && !is_string($primaryEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryEmailAddress)), __LINE__);
        }
        $this->PrimaryEmailAddress = $primaryEmailAddress;
        return $this;
    }
    /**
     * Get PrimaryPhone value
     * @return string|null
     */
    public function getPrimaryPhone()
    {
        return $this->PrimaryPhone;
    }
    /**
     * Set PrimaryPhone value
     * @param string $primaryPhone
     * @return \StructType\EditOrganizationParameters
     */
    public function setPrimaryPhone($primaryPhone = null)
    {
        // validation for constraint: string
        if (!is_null($primaryPhone) && !is_string($primaryPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryPhone)), __LINE__);
        }
        $this->PrimaryPhone = $primaryPhone;
        return $this;
    }
    /**
     * Get PrimaryFax value
     * @return string|null
     */
    public function getPrimaryFax()
    {
        return $this->PrimaryFax;
    }
    /**
     * Set PrimaryFax value
     * @param string $primaryFax
     * @return \StructType\EditOrganizationParameters
     */
    public function setPrimaryFax($primaryFax = null)
    {
        // validation for constraint: string
        if (!is_null($primaryFax) && !is_string($primaryFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryFax)), __LINE__);
        }
        $this->PrimaryFax = $primaryFax;
        return $this;
    }
    /**
     * Get PrimarySms value
     * @return string|null
     */
    public function getPrimarySms()
    {
        return $this->PrimarySms;
    }
    /**
     * Set PrimarySms value
     * @param string $primarySms
     * @return \StructType\EditOrganizationParameters
     */
    public function setPrimarySms($primarySms = null)
    {
        // validation for constraint: string
        if (!is_null($primarySms) && !is_string($primarySms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primarySms)), __LINE__);
        }
        $this->PrimarySms = $primarySms;
        return $this;
    }
    /**
     * Get SyncExternalId value
     * @return string|null
     */
    public function getSyncExternalId()
    {
        return $this->SyncExternalId;
    }
    /**
     * Set SyncExternalId value
     * @param string $syncExternalId
     * @return \StructType\EditOrganizationParameters
     */
    public function setSyncExternalId($syncExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($syncExternalId) && !is_string($syncExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($syncExternalId)), __LINE__);
        }
        $this->SyncExternalId = $syncExternalId;
        return $this;
    }
    /**
     * Get Groups value
     * @return \ArrayType\ArrayOfChangeContactGroupParameters|null
     */
    public function getGroups()
    {
        return $this->Groups;
    }
    /**
     * Set Groups value
     * @param \ArrayType\ArrayOfChangeContactGroupParameters $groups
     * @return \StructType\EditOrganizationParameters
     */
    public function setGroups(\ArrayType\ArrayOfChangeContactGroupParameters $groups = null)
    {
        $this->Groups = $groups;
        return $this;
    }
    /**
     * Get Tags value
     * @return \ArrayType\ArrayOfChangeContactTagParameters|null
     */
    public function getTags()
    {
        return $this->Tags;
    }
    /**
     * Set Tags value
     * @param \ArrayType\ArrayOfChangeContactTagParameters $tags
     * @return \StructType\EditOrganizationParameters
     */
    public function setTags(\ArrayType\ArrayOfChangeContactTagParameters $tags = null)
    {
        $this->Tags = $tags;
        return $this;
    }
    /**
     * Get OptInLists value
     * @return \ArrayType\ArrayOfChangeContactOptInListParameters|null
     */
    public function getOptInLists()
    {
        return $this->OptInLists;
    }
    /**
     * Set OptInLists value
     * @param \ArrayType\ArrayOfChangeContactOptInListParameters $optInLists
     * @return \StructType\EditOrganizationParameters
     */
    public function setOptInLists(\ArrayType\ArrayOfChangeContactOptInListParameters $optInLists = null)
    {
        $this->OptInLists = $optInLists;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \ArrayType\ArrayOfEditContactCustomFieldParameters|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \ArrayType\ArrayOfEditContactCustomFieldParameters $customFields
     * @return \StructType\EditOrganizationParameters
     */
    public function setCustomFields(\ArrayType\ArrayOfEditContactCustomFieldParameters $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditOrganizationParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
