<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditNoteParameters StructType
 * @subpackage Structs
 */
class EditNoteParameters extends EditRecordParameters
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The CreatedByContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $CreatedByContact;
    /**
     * The NoteContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoteContent;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $Contact;
    /**
     * The Transaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateTransactionParameters
     */
    public $Transaction;
    /**
     * The Order
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateOrderParameters
     */
    public $Order;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateActivityParameters
     */
    public $Activity;
    /**
     * The Relationship
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateRelationshipParameters
     */
    public $Relationship;
    /**
     * The Case
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateCaseParameters
     */
    public $Case;
    /**
     * Constructor method for EditNoteParameters
     * @uses EditNoteParameters::setType()
     * @uses EditNoteParameters::setActive()
     * @uses EditNoteParameters::setCreatedByContact()
     * @uses EditNoteParameters::setNoteContent()
     * @uses EditNoteParameters::setContact()
     * @uses EditNoteParameters::setTransaction()
     * @uses EditNoteParameters::setOrder()
     * @uses EditNoteParameters::setActivity()
     * @uses EditNoteParameters::setRelationship()
     * @uses EditNoteParameters::setCase()
     * @param string $type
     * @param bool $active
     * @param \StructType\FindOrCreateContactParameters $createdByContact
     * @param string $noteContent
     * @param \StructType\FindOrCreateContactParameters $contact
     * @param \StructType\FindOrCreateTransactionParameters $transaction
     * @param \StructType\FindOrCreateOrderParameters $order
     * @param \StructType\FindOrCreateActivityParameters $activity
     * @param \StructType\FindOrCreateRelationshipParameters $relationship
     * @param \StructType\FindOrCreateCaseParameters $case
     */
    public function __construct($type = null, $active = null, \StructType\FindOrCreateContactParameters $createdByContact = null, $noteContent = null, \StructType\FindOrCreateContactParameters $contact = null, \StructType\FindOrCreateTransactionParameters $transaction = null, \StructType\FindOrCreateOrderParameters $order = null, \StructType\FindOrCreateActivityParameters $activity = null, \StructType\FindOrCreateRelationshipParameters $relationship = null, \StructType\FindOrCreateCaseParameters $case = null)
    {
        $this
            ->setType($type)
            ->setActive($active)
            ->setCreatedByContact($createdByContact)
            ->setNoteContent($noteContent)
            ->setContact($contact)
            ->setTransaction($transaction)
            ->setOrder($order)
            ->setActivity($activity)
            ->setRelationship($relationship)
            ->setCase($case);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\NoteTypes::valueIsValid()
     * @uses \EnumType\NoteTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\EditNoteParameters
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NoteTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\NoteTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\EditNoteParameters
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get CreatedByContact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getCreatedByContact()
    {
        return $this->CreatedByContact;
    }
    /**
     * Set CreatedByContact value
     * @param \StructType\FindOrCreateContactParameters $createdByContact
     * @return \StructType\EditNoteParameters
     */
    public function setCreatedByContact(\StructType\FindOrCreateContactParameters $createdByContact = null)
    {
        $this->CreatedByContact = $createdByContact;
        return $this;
    }
    /**
     * Get NoteContent value
     * @return string|null
     */
    public function getNoteContent()
    {
        return $this->NoteContent;
    }
    /**
     * Set NoteContent value
     * @param string $noteContent
     * @return \StructType\EditNoteParameters
     */
    public function setNoteContent($noteContent = null)
    {
        // validation for constraint: string
        if (!is_null($noteContent) && !is_string($noteContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noteContent)), __LINE__);
        }
        $this->NoteContent = $noteContent;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\FindOrCreateContactParameters $contact
     * @return \StructType\EditNoteParameters
     */
    public function setContact(\StructType\FindOrCreateContactParameters $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Transaction value
     * @return \StructType\FindOrCreateTransactionParameters|null
     */
    public function getTransaction()
    {
        return $this->Transaction;
    }
    /**
     * Set Transaction value
     * @param \StructType\FindOrCreateTransactionParameters $transaction
     * @return \StructType\EditNoteParameters
     */
    public function setTransaction(\StructType\FindOrCreateTransactionParameters $transaction = null)
    {
        $this->Transaction = $transaction;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\FindOrCreateOrderParameters|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\FindOrCreateOrderParameters $order
     * @return \StructType\EditNoteParameters
     */
    public function setOrder(\StructType\FindOrCreateOrderParameters $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\FindOrCreateActivityParameters|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\FindOrCreateActivityParameters $activity
     * @return \StructType\EditNoteParameters
     */
    public function setActivity(\StructType\FindOrCreateActivityParameters $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Relationship value
     * @return \StructType\FindOrCreateRelationshipParameters|null
     */
    public function getRelationship()
    {
        return $this->Relationship;
    }
    /**
     * Set Relationship value
     * @param \StructType\FindOrCreateRelationshipParameters $relationship
     * @return \StructType\EditNoteParameters
     */
    public function setRelationship(\StructType\FindOrCreateRelationshipParameters $relationship = null)
    {
        $this->Relationship = $relationship;
        return $this;
    }
    /**
     * Get Case value
     * @return \StructType\FindOrCreateCaseParameters|null
     */
    public function getCase()
    {
        return $this->Case;
    }
    /**
     * Set Case value
     * @param \StructType\FindOrCreateCaseParameters $case
     * @return \StructType\EditNoteParameters
     */
    public function setCase(\StructType\FindOrCreateCaseParameters $case = null)
    {
        $this->Case = $case;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditNoteParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
