<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditNonElectronicPaymentParameters StructType
 * @subpackage Structs
 */
class EditNonElectronicPaymentParameters extends EditRecordParameters
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The TaxDeductibleAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxDeductibleAmount;
    /**
     * The PaymentConfirmed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PaymentConfirmed;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $Contact;
    /**
     * The CheckNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckNumber;
    /**
     * The PaymentBillingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentBillingContactParameters
     */
    public $PaymentBillingInfo;
    /**
     * The Attribution
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttributionParameters
     */
    public $Attribution;
    /**
     * The PrivacyPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentPrivacyPreferenceParameters
     */
    public $PrivacyPreferences;
    /**
     * The UpdateContactActions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactUpdateActionParameters
     */
    public $UpdateContactActions;
    /**
     * Constructor method for EditNonElectronicPaymentParameters
     * @uses EditNonElectronicPaymentParameters::setAmount()
     * @uses EditNonElectronicPaymentParameters::setTaxDeductibleAmount()
     * @uses EditNonElectronicPaymentParameters::setPaymentConfirmed()
     * @uses EditNonElectronicPaymentParameters::setContact()
     * @uses EditNonElectronicPaymentParameters::setCheckNumber()
     * @uses EditNonElectronicPaymentParameters::setPaymentBillingInfo()
     * @uses EditNonElectronicPaymentParameters::setAttribution()
     * @uses EditNonElectronicPaymentParameters::setPrivacyPreferences()
     * @uses EditNonElectronicPaymentParameters::setUpdateContactActions()
     * @param float $amount
     * @param float $taxDeductibleAmount
     * @param bool $paymentConfirmed
     * @param \StructType\FindOrCreateContactParameters $contact
     * @param string $checkNumber
     * @param \StructType\PaymentBillingContactParameters $paymentBillingInfo
     * @param \StructType\AttributionParameters $attribution
     * @param \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences
     * @param \StructType\ContactUpdateActionParameters $updateContactActions
     */
    public function __construct($amount = null, $taxDeductibleAmount = null, $paymentConfirmed = null, \StructType\FindOrCreateContactParameters $contact = null, $checkNumber = null, \StructType\PaymentBillingContactParameters $paymentBillingInfo = null, \StructType\AttributionParameters $attribution = null, \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences = null, \StructType\ContactUpdateActionParameters $updateContactActions = null)
    {
        $this
            ->setAmount($amount)
            ->setTaxDeductibleAmount($taxDeductibleAmount)
            ->setPaymentConfirmed($paymentConfirmed)
            ->setContact($contact)
            ->setCheckNumber($checkNumber)
            ->setPaymentBillingInfo($paymentBillingInfo)
            ->setAttribution($attribution)
            ->setPrivacyPreferences($privacyPreferences)
            ->setUpdateContactActions($updateContactActions);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\EditNonElectronicPaymentParameters
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxDeductibleAmount value
     * @return float
     */
    public function getTaxDeductibleAmount()
    {
        return $this->TaxDeductibleAmount;
    }
    /**
     * Set TaxDeductibleAmount value
     * @param float $taxDeductibleAmount
     * @return \StructType\EditNonElectronicPaymentParameters
     */
    public function setTaxDeductibleAmount($taxDeductibleAmount = null)
    {
        $this->TaxDeductibleAmount = $taxDeductibleAmount;
        return $this;
    }
    /**
     * Get PaymentConfirmed value
     * @return bool
     */
    public function getPaymentConfirmed()
    {
        return $this->PaymentConfirmed;
    }
    /**
     * Set PaymentConfirmed value
     * @param bool $paymentConfirmed
     * @return \StructType\EditNonElectronicPaymentParameters
     */
    public function setPaymentConfirmed($paymentConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentConfirmed) && !is_bool($paymentConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($paymentConfirmed)), __LINE__);
        }
        $this->PaymentConfirmed = $paymentConfirmed;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\FindOrCreateContactParameters $contact
     * @return \StructType\EditNonElectronicPaymentParameters
     */
    public function setContact(\StructType\FindOrCreateContactParameters $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get CheckNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param string $checkNumber
     * @return \StructType\EditNonElectronicPaymentParameters
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Get PaymentBillingInfo value
     * @return \StructType\PaymentBillingContactParameters|null
     */
    public function getPaymentBillingInfo()
    {
        return $this->PaymentBillingInfo;
    }
    /**
     * Set PaymentBillingInfo value
     * @param \StructType\PaymentBillingContactParameters $paymentBillingInfo
     * @return \StructType\EditNonElectronicPaymentParameters
     */
    public function setPaymentBillingInfo(\StructType\PaymentBillingContactParameters $paymentBillingInfo = null)
    {
        $this->PaymentBillingInfo = $paymentBillingInfo;
        return $this;
    }
    /**
     * Get Attribution value
     * @return \StructType\AttributionParameters|null
     */
    public function getAttribution()
    {
        return $this->Attribution;
    }
    /**
     * Set Attribution value
     * @param \StructType\AttributionParameters $attribution
     * @return \StructType\EditNonElectronicPaymentParameters
     */
    public function setAttribution(\StructType\AttributionParameters $attribution = null)
    {
        $this->Attribution = $attribution;
        return $this;
    }
    /**
     * Get PrivacyPreferences value
     * @return \StructType\PaymentPrivacyPreferenceParameters|null
     */
    public function getPrivacyPreferences()
    {
        return $this->PrivacyPreferences;
    }
    /**
     * Set PrivacyPreferences value
     * @param \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences
     * @return \StructType\EditNonElectronicPaymentParameters
     */
    public function setPrivacyPreferences(\StructType\PaymentPrivacyPreferenceParameters $privacyPreferences = null)
    {
        $this->PrivacyPreferences = $privacyPreferences;
        return $this;
    }
    /**
     * Get UpdateContactActions value
     * @return \StructType\ContactUpdateActionParameters|null
     */
    public function getUpdateContactActions()
    {
        return $this->UpdateContactActions;
    }
    /**
     * Set UpdateContactActions value
     * @param \StructType\ContactUpdateActionParameters $updateContactActions
     * @return \StructType\EditNonElectronicPaymentParameters
     */
    public function setUpdateContactActions(\StructType\ContactUpdateActionParameters $updateContactActions = null)
    {
        $this->UpdateContactActions = $updateContactActions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditNonElectronicPaymentParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
