<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditElectronicPaymentParameters StructType
 * @subpackage Structs
 */
class EditElectronicPaymentParameters extends EditRecordParameters
{
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $Contact;
    /**
     * The Attribution
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttributionParameters
     */
    public $Attribution;
    /**
     * The PrivacyPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentPrivacyPreferenceParameters
     */
    public $PrivacyPreferences;
    /**
     * The UpdateContactActions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactUpdateActionParameters
     */
    public $UpdateContactActions;
    /**
     * Constructor method for EditElectronicPaymentParameters
     * @uses EditElectronicPaymentParameters::setContact()
     * @uses EditElectronicPaymentParameters::setAttribution()
     * @uses EditElectronicPaymentParameters::setPrivacyPreferences()
     * @uses EditElectronicPaymentParameters::setUpdateContactActions()
     * @param \StructType\FindOrCreateContactParameters $contact
     * @param \StructType\AttributionParameters $attribution
     * @param \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences
     * @param \StructType\ContactUpdateActionParameters $updateContactActions
     */
    public function __construct(\StructType\FindOrCreateContactParameters $contact = null, \StructType\AttributionParameters $attribution = null, \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences = null, \StructType\ContactUpdateActionParameters $updateContactActions = null)
    {
        $this
            ->setContact($contact)
            ->setAttribution($attribution)
            ->setPrivacyPreferences($privacyPreferences)
            ->setUpdateContactActions($updateContactActions);
    }
    /**
     * Get Contact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\FindOrCreateContactParameters $contact
     * @return \StructType\EditElectronicPaymentParameters
     */
    public function setContact(\StructType\FindOrCreateContactParameters $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Attribution value
     * @return \StructType\AttributionParameters|null
     */
    public function getAttribution()
    {
        return $this->Attribution;
    }
    /**
     * Set Attribution value
     * @param \StructType\AttributionParameters $attribution
     * @return \StructType\EditElectronicPaymentParameters
     */
    public function setAttribution(\StructType\AttributionParameters $attribution = null)
    {
        $this->Attribution = $attribution;
        return $this;
    }
    /**
     * Get PrivacyPreferences value
     * @return \StructType\PaymentPrivacyPreferenceParameters|null
     */
    public function getPrivacyPreferences()
    {
        return $this->PrivacyPreferences;
    }
    /**
     * Set PrivacyPreferences value
     * @param \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences
     * @return \StructType\EditElectronicPaymentParameters
     */
    public function setPrivacyPreferences(\StructType\PaymentPrivacyPreferenceParameters $privacyPreferences = null)
    {
        $this->PrivacyPreferences = $privacyPreferences;
        return $this;
    }
    /**
     * Get UpdateContactActions value
     * @return \StructType\ContactUpdateActionParameters|null
     */
    public function getUpdateContactActions()
    {
        return $this->UpdateContactActions;
    }
    /**
     * Set UpdateContactActions value
     * @param \StructType\ContactUpdateActionParameters $updateContactActions
     * @return \StructType\EditElectronicPaymentParameters
     */
    public function setUpdateContactActions(\StructType\ContactUpdateActionParameters $updateContactActions = null)
    {
        $this->UpdateContactActions = $updateContactActions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditElectronicPaymentParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
