<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditAddressParameters StructType
 * @subpackage Structs
 */
class EditAddressParameters extends EditRecordParameters
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The Class
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Class;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The MailOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $MailOptIn;
    /**
     * The PreferredMailingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PreferredMailingAddress;
    /**
     * The PreferredShippingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PreferredShippingAddress;
    /**
     * The SeasonalMonthFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SeasonalMonthFrom;
    /**
     * The SeasonalDayFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SeasonalDayFrom;
    /**
     * The SeasonalMonthTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SeasonalMonthTo;
    /**
     * The SeasonalDayTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SeasonalDayTo;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $Contact;
    /**
     * The AddressStreet1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStreet1;
    /**
     * The AddressStreet2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStreet2;
    /**
     * The AddressCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressCity;
    /**
     * The AddressStateProvince
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStateProvince;
    /**
     * The AddressPostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressPostalCode;
    /**
     * The AddressStateCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStateCountry;
    /**
     * Constructor method for EditAddressParameters
     * @uses EditAddressParameters::setType()
     * @uses EditAddressParameters::setClass()
     * @uses EditAddressParameters::setActive()
     * @uses EditAddressParameters::setMailOptIn()
     * @uses EditAddressParameters::setPreferredMailingAddress()
     * @uses EditAddressParameters::setPreferredShippingAddress()
     * @uses EditAddressParameters::setSeasonalMonthFrom()
     * @uses EditAddressParameters::setSeasonalDayFrom()
     * @uses EditAddressParameters::setSeasonalMonthTo()
     * @uses EditAddressParameters::setSeasonalDayTo()
     * @uses EditAddressParameters::setContact()
     * @uses EditAddressParameters::setAddressStreet1()
     * @uses EditAddressParameters::setAddressStreet2()
     * @uses EditAddressParameters::setAddressCity()
     * @uses EditAddressParameters::setAddressStateProvince()
     * @uses EditAddressParameters::setAddressPostalCode()
     * @uses EditAddressParameters::setAddressStateCountry()
     * @param string $type
     * @param string $class
     * @param bool $active
     * @param bool $mailOptIn
     * @param bool $preferredMailingAddress
     * @param bool $preferredShippingAddress
     * @param int $seasonalMonthFrom
     * @param int $seasonalDayFrom
     * @param int $seasonalMonthTo
     * @param int $seasonalDayTo
     * @param \StructType\FindOrCreateContactParameters $contact
     * @param string $addressStreet1
     * @param string $addressStreet2
     * @param string $addressCity
     * @param string $addressStateProvince
     * @param string $addressPostalCode
     * @param string $addressStateCountry
     */
    public function __construct($type = null, $class = null, $active = null, $mailOptIn = null, $preferredMailingAddress = null, $preferredShippingAddress = null, $seasonalMonthFrom = null, $seasonalDayFrom = null, $seasonalMonthTo = null, $seasonalDayTo = null, \StructType\FindOrCreateContactParameters $contact = null, $addressStreet1 = null, $addressStreet2 = null, $addressCity = null, $addressStateProvince = null, $addressPostalCode = null, $addressStateCountry = null)
    {
        $this
            ->setType($type)
            ->setClass($class)
            ->setActive($active)
            ->setMailOptIn($mailOptIn)
            ->setPreferredMailingAddress($preferredMailingAddress)
            ->setPreferredShippingAddress($preferredShippingAddress)
            ->setSeasonalMonthFrom($seasonalMonthFrom)
            ->setSeasonalDayFrom($seasonalDayFrom)
            ->setSeasonalMonthTo($seasonalMonthTo)
            ->setSeasonalDayTo($seasonalDayTo)
            ->setContact($contact)
            ->setAddressStreet1($addressStreet1)
            ->setAddressStreet2($addressStreet2)
            ->setAddressCity($addressCity)
            ->setAddressStateProvince($addressStateProvince)
            ->setAddressPostalCode($addressPostalCode)
            ->setAddressStateCountry($addressStateCountry);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\AddressTypes::valueIsValid()
     * @uses \EnumType\AddressTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\EditAddressParameters
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\AddressTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Class value
     * @return string
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @uses \EnumType\AddressClasses::valueIsValid()
     * @uses \EnumType\AddressClasses::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \StructType\EditAddressParameters
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressClasses::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \EnumType\AddressClasses::getValidValues())), __LINE__);
        }
        $this->Class = $class;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\EditAddressParameters
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get MailOptIn value
     * @return bool
     */
    public function getMailOptIn()
    {
        return $this->MailOptIn;
    }
    /**
     * Set MailOptIn value
     * @param bool $mailOptIn
     * @return \StructType\EditAddressParameters
     */
    public function setMailOptIn($mailOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailOptIn) && !is_bool($mailOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mailOptIn)), __LINE__);
        }
        $this->MailOptIn = $mailOptIn;
        return $this;
    }
    /**
     * Get PreferredMailingAddress value
     * @return bool
     */
    public function getPreferredMailingAddress()
    {
        return $this->PreferredMailingAddress;
    }
    /**
     * Set PreferredMailingAddress value
     * @param bool $preferredMailingAddress
     * @return \StructType\EditAddressParameters
     */
    public function setPreferredMailingAddress($preferredMailingAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferredMailingAddress) && !is_bool($preferredMailingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($preferredMailingAddress)), __LINE__);
        }
        $this->PreferredMailingAddress = $preferredMailingAddress;
        return $this;
    }
    /**
     * Get PreferredShippingAddress value
     * @return bool
     */
    public function getPreferredShippingAddress()
    {
        return $this->PreferredShippingAddress;
    }
    /**
     * Set PreferredShippingAddress value
     * @param bool $preferredShippingAddress
     * @return \StructType\EditAddressParameters
     */
    public function setPreferredShippingAddress($preferredShippingAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferredShippingAddress) && !is_bool($preferredShippingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($preferredShippingAddress)), __LINE__);
        }
        $this->PreferredShippingAddress = $preferredShippingAddress;
        return $this;
    }
    /**
     * Get SeasonalMonthFrom value
     * @return int
     */
    public function getSeasonalMonthFrom()
    {
        return $this->SeasonalMonthFrom;
    }
    /**
     * Set SeasonalMonthFrom value
     * @param int $seasonalMonthFrom
     * @return \StructType\EditAddressParameters
     */
    public function setSeasonalMonthFrom($seasonalMonthFrom = null)
    {
        // validation for constraint: int
        if (!is_null($seasonalMonthFrom) && !is_numeric($seasonalMonthFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seasonalMonthFrom)), __LINE__);
        }
        $this->SeasonalMonthFrom = $seasonalMonthFrom;
        return $this;
    }
    /**
     * Get SeasonalDayFrom value
     * @return int
     */
    public function getSeasonalDayFrom()
    {
        return $this->SeasonalDayFrom;
    }
    /**
     * Set SeasonalDayFrom value
     * @param int $seasonalDayFrom
     * @return \StructType\EditAddressParameters
     */
    public function setSeasonalDayFrom($seasonalDayFrom = null)
    {
        // validation for constraint: int
        if (!is_null($seasonalDayFrom) && !is_numeric($seasonalDayFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seasonalDayFrom)), __LINE__);
        }
        $this->SeasonalDayFrom = $seasonalDayFrom;
        return $this;
    }
    /**
     * Get SeasonalMonthTo value
     * @return int
     */
    public function getSeasonalMonthTo()
    {
        return $this->SeasonalMonthTo;
    }
    /**
     * Set SeasonalMonthTo value
     * @param int $seasonalMonthTo
     * @return \StructType\EditAddressParameters
     */
    public function setSeasonalMonthTo($seasonalMonthTo = null)
    {
        // validation for constraint: int
        if (!is_null($seasonalMonthTo) && !is_numeric($seasonalMonthTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seasonalMonthTo)), __LINE__);
        }
        $this->SeasonalMonthTo = $seasonalMonthTo;
        return $this;
    }
    /**
     * Get SeasonalDayTo value
     * @return int
     */
    public function getSeasonalDayTo()
    {
        return $this->SeasonalDayTo;
    }
    /**
     * Set SeasonalDayTo value
     * @param int $seasonalDayTo
     * @return \StructType\EditAddressParameters
     */
    public function setSeasonalDayTo($seasonalDayTo = null)
    {
        // validation for constraint: int
        if (!is_null($seasonalDayTo) && !is_numeric($seasonalDayTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seasonalDayTo)), __LINE__);
        }
        $this->SeasonalDayTo = $seasonalDayTo;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\FindOrCreateContactParameters $contact
     * @return \StructType\EditAddressParameters
     */
    public function setContact(\StructType\FindOrCreateContactParameters $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get AddressStreet1 value
     * @return string|null
     */
    public function getAddressStreet1()
    {
        return $this->AddressStreet1;
    }
    /**
     * Set AddressStreet1 value
     * @param string $addressStreet1
     * @return \StructType\EditAddressParameters
     */
    public function setAddressStreet1($addressStreet1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressStreet1) && !is_string($addressStreet1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStreet1)), __LINE__);
        }
        $this->AddressStreet1 = $addressStreet1;
        return $this;
    }
    /**
     * Get AddressStreet2 value
     * @return string|null
     */
    public function getAddressStreet2()
    {
        return $this->AddressStreet2;
    }
    /**
     * Set AddressStreet2 value
     * @param string $addressStreet2
     * @return \StructType\EditAddressParameters
     */
    public function setAddressStreet2($addressStreet2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressStreet2) && !is_string($addressStreet2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStreet2)), __LINE__);
        }
        $this->AddressStreet2 = $addressStreet2;
        return $this;
    }
    /**
     * Get AddressCity value
     * @return string|null
     */
    public function getAddressCity()
    {
        return $this->AddressCity;
    }
    /**
     * Set AddressCity value
     * @param string $addressCity
     * @return \StructType\EditAddressParameters
     */
    public function setAddressCity($addressCity = null)
    {
        // validation for constraint: string
        if (!is_null($addressCity) && !is_string($addressCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressCity)), __LINE__);
        }
        $this->AddressCity = $addressCity;
        return $this;
    }
    /**
     * Get AddressStateProvince value
     * @return string|null
     */
    public function getAddressStateProvince()
    {
        return $this->AddressStateProvince;
    }
    /**
     * Set AddressStateProvince value
     * @param string $addressStateProvince
     * @return \StructType\EditAddressParameters
     */
    public function setAddressStateProvince($addressStateProvince = null)
    {
        // validation for constraint: string
        if (!is_null($addressStateProvince) && !is_string($addressStateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStateProvince)), __LINE__);
        }
        $this->AddressStateProvince = $addressStateProvince;
        return $this;
    }
    /**
     * Get AddressPostalCode value
     * @return string|null
     */
    public function getAddressPostalCode()
    {
        return $this->AddressPostalCode;
    }
    /**
     * Set AddressPostalCode value
     * @param string $addressPostalCode
     * @return \StructType\EditAddressParameters
     */
    public function setAddressPostalCode($addressPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($addressPostalCode) && !is_string($addressPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressPostalCode)), __LINE__);
        }
        $this->AddressPostalCode = $addressPostalCode;
        return $this;
    }
    /**
     * Get AddressStateCountry value
     * @return string|null
     */
    public function getAddressStateCountry()
    {
        return $this->AddressStateCountry;
    }
    /**
     * Set AddressStateCountry value
     * @param string $addressStateCountry
     * @return \StructType\EditAddressParameters
     */
    public function setAddressStateCountry($addressStateCountry = null)
    {
        // validation for constraint: string
        if (!is_null($addressStateCountry) && !is_string($addressStateCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStateCountry)), __LINE__);
        }
        $this->AddressStateCountry = $addressStateCountry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditAddressParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
