<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditActivityParameters StructType
 * @subpackage Structs
 */
class EditActivityParameters extends EditRecordParameters
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The OpportunityTypeTrackStep_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OpportunityTypeTrackStep_Id;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateActivityTypeParameters
     */
    public $Type;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateActivityStatusParameters
     */
    public $Status;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Location;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Opportunity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateOpportunityParameters
     */
    public $Opportunity;
    /**
     * The Case
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateCaseParameters
     */
    public $Case;
    /**
     * The ParticipatingContacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfChangeActivityParticipatingContactParameters
     */
    public $ParticipatingContacts;
    /**
     * The AssignedContacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfChangeActivityAssignedContactParameters
     */
    public $AssignedContacts;
    /**
     * The CreatedByContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $CreatedByContact;
    /**
     * Constructor method for EditActivityParameters
     * @uses EditActivityParameters::setStartDate()
     * @uses EditActivityParameters::setEndDate()
     * @uses EditActivityParameters::setOpportunityTypeTrackStep_Id()
     * @uses EditActivityParameters::setType()
     * @uses EditActivityParameters::setStatus()
     * @uses EditActivityParameters::setTitle()
     * @uses EditActivityParameters::setLocation()
     * @uses EditActivityParameters::setDescription()
     * @uses EditActivityParameters::setOpportunity()
     * @uses EditActivityParameters::setCase()
     * @uses EditActivityParameters::setParticipatingContacts()
     * @uses EditActivityParameters::setAssignedContacts()
     * @uses EditActivityParameters::setCreatedByContact()
     * @param string $startDate
     * @param string $endDate
     * @param int $opportunityTypeTrackStep_Id
     * @param \StructType\FindOrCreateActivityTypeParameters $type
     * @param \StructType\FindOrCreateActivityStatusParameters $status
     * @param string $title
     * @param string $location
     * @param string $description
     * @param \StructType\FindOrCreateOpportunityParameters $opportunity
     * @param \StructType\FindOrCreateCaseParameters $case
     * @param \ArrayType\ArrayOfChangeActivityParticipatingContactParameters $participatingContacts
     * @param \ArrayType\ArrayOfChangeActivityAssignedContactParameters $assignedContacts
     * @param \StructType\FindOrCreateContactParameters $createdByContact
     */
    public function __construct($startDate = null, $endDate = null, $opportunityTypeTrackStep_Id = null, \StructType\FindOrCreateActivityTypeParameters $type = null, \StructType\FindOrCreateActivityStatusParameters $status = null, $title = null, $location = null, $description = null, \StructType\FindOrCreateOpportunityParameters $opportunity = null, \StructType\FindOrCreateCaseParameters $case = null, \ArrayType\ArrayOfChangeActivityParticipatingContactParameters $participatingContacts = null, \ArrayType\ArrayOfChangeActivityAssignedContactParameters $assignedContacts = null, \StructType\FindOrCreateContactParameters $createdByContact = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setOpportunityTypeTrackStep_Id($opportunityTypeTrackStep_Id)
            ->setType($type)
            ->setStatus($status)
            ->setTitle($title)
            ->setLocation($location)
            ->setDescription($description)
            ->setOpportunity($opportunity)
            ->setCase($case)
            ->setParticipatingContacts($participatingContacts)
            ->setAssignedContacts($assignedContacts)
            ->setCreatedByContact($createdByContact);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\EditActivityParameters
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\EditActivityParameters
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get OpportunityTypeTrackStep_Id value
     * @return int
     */
    public function getOpportunityTypeTrackStep_Id()
    {
        return $this->OpportunityTypeTrackStep_Id;
    }
    /**
     * Set OpportunityTypeTrackStep_Id value
     * @param int $opportunityTypeTrackStep_Id
     * @return \StructType\EditActivityParameters
     */
    public function setOpportunityTypeTrackStep_Id($opportunityTypeTrackStep_Id = null)
    {
        // validation for constraint: int
        if (!is_null($opportunityTypeTrackStep_Id) && !is_numeric($opportunityTypeTrackStep_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($opportunityTypeTrackStep_Id)), __LINE__);
        }
        $this->OpportunityTypeTrackStep_Id = $opportunityTypeTrackStep_Id;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\FindOrCreateActivityTypeParameters|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\FindOrCreateActivityTypeParameters $type
     * @return \StructType\EditActivityParameters
     */
    public function setType(\StructType\FindOrCreateActivityTypeParameters $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\FindOrCreateActivityStatusParameters|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\FindOrCreateActivityStatusParameters $status
     * @return \StructType\EditActivityParameters
     */
    public function setStatus(\StructType\FindOrCreateActivityStatusParameters $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\EditActivityParameters
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\EditActivityParameters
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\EditActivityParameters
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Opportunity value
     * @return \StructType\FindOrCreateOpportunityParameters|null
     */
    public function getOpportunity()
    {
        return $this->Opportunity;
    }
    /**
     * Set Opportunity value
     * @param \StructType\FindOrCreateOpportunityParameters $opportunity
     * @return \StructType\EditActivityParameters
     */
    public function setOpportunity(\StructType\FindOrCreateOpportunityParameters $opportunity = null)
    {
        $this->Opportunity = $opportunity;
        return $this;
    }
    /**
     * Get Case value
     * @return \StructType\FindOrCreateCaseParameters|null
     */
    public function getCase()
    {
        return $this->Case;
    }
    /**
     * Set Case value
     * @param \StructType\FindOrCreateCaseParameters $case
     * @return \StructType\EditActivityParameters
     */
    public function setCase(\StructType\FindOrCreateCaseParameters $case = null)
    {
        $this->Case = $case;
        return $this;
    }
    /**
     * Get ParticipatingContacts value
     * @return \ArrayType\ArrayOfChangeActivityParticipatingContactParameters|null
     */
    public function getParticipatingContacts()
    {
        return $this->ParticipatingContacts;
    }
    /**
     * Set ParticipatingContacts value
     * @param \ArrayType\ArrayOfChangeActivityParticipatingContactParameters $participatingContacts
     * @return \StructType\EditActivityParameters
     */
    public function setParticipatingContacts(\ArrayType\ArrayOfChangeActivityParticipatingContactParameters $participatingContacts = null)
    {
        $this->ParticipatingContacts = $participatingContacts;
        return $this;
    }
    /**
     * Get AssignedContacts value
     * @return \ArrayType\ArrayOfChangeActivityAssignedContactParameters|null
     */
    public function getAssignedContacts()
    {
        return $this->AssignedContacts;
    }
    /**
     * Set AssignedContacts value
     * @param \ArrayType\ArrayOfChangeActivityAssignedContactParameters $assignedContacts
     * @return \StructType\EditActivityParameters
     */
    public function setAssignedContacts(\ArrayType\ArrayOfChangeActivityAssignedContactParameters $assignedContacts = null)
    {
        $this->AssignedContacts = $assignedContacts;
        return $this;
    }
    /**
     * Get CreatedByContact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getCreatedByContact()
    {
        return $this->CreatedByContact;
    }
    /**
     * Set CreatedByContact value
     * @param \StructType\FindOrCreateContactParameters $createdByContact
     * @return \StructType\EditActivityParameters
     */
    public function setCreatedByContact(\StructType\FindOrCreateContactParameters $createdByContact = null)
    {
        $this->CreatedByContact = $createdByContact;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditActivityParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
