<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateAdvancedPagingQuery StructType
 * @subpackage Structs
 */
class DateAdvancedPagingQuery extends DatePagingQuery
{
    /**
     * The DateModifiedFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateModifiedFrom;
    /**
     * The DateModifiedTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateModifiedTo;
    /**
     * Constructor method for DateAdvancedPagingQuery
     * @uses DateAdvancedPagingQuery::setDateModifiedFrom()
     * @uses DateAdvancedPagingQuery::setDateModifiedTo()
     * @param string $dateModifiedFrom
     * @param string $dateModifiedTo
     */
    public function __construct($dateModifiedFrom = null, $dateModifiedTo = null)
    {
        $this
            ->setDateModifiedFrom($dateModifiedFrom)
            ->setDateModifiedTo($dateModifiedTo);
    }
    /**
     * Get DateModifiedFrom value
     * @return string
     */
    public function getDateModifiedFrom()
    {
        return $this->DateModifiedFrom;
    }
    /**
     * Set DateModifiedFrom value
     * @param string $dateModifiedFrom
     * @return \StructType\DateAdvancedPagingQuery
     */
    public function setDateModifiedFrom($dateModifiedFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateModifiedFrom) && !is_string($dateModifiedFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateModifiedFrom)), __LINE__);
        }
        $this->DateModifiedFrom = $dateModifiedFrom;
        return $this;
    }
    /**
     * Get DateModifiedTo value
     * @return string
     */
    public function getDateModifiedTo()
    {
        return $this->DateModifiedTo;
    }
    /**
     * Set DateModifiedTo value
     * @param string $dateModifiedTo
     * @return \StructType\DateAdvancedPagingQuery
     */
    public function setDateModifiedTo($dateModifiedTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateModifiedTo) && !is_string($dateModifiedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateModifiedTo)), __LINE__);
        }
        $this->DateModifiedTo = $dateModifiedTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DateAdvancedPagingQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
