<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerDetail StructType
 * @subpackage Structs
 */
class CustomerDetail extends GroupedProperties
{
    /**
     * The EmailOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EmailOptIn;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The RelatedOrganizationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RelatedOrganizationName;
    /**
     * The AddressStreet1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStreet1;
    /**
     * The AddressStreet2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStreet2;
    /**
     * The AddressCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressCity;
    /**
     * The AddressStateProvince
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStateProvince;
    /**
     * The AddressPostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressPostalCode;
    /**
     * The AddressCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressCountry;
    /**
     * Constructor method for CustomerDetail
     * @uses CustomerDetail::setEmailOptIn()
     * @uses CustomerDetail::setFirstName()
     * @uses CustomerDetail::setLastName()
     * @uses CustomerDetail::setEmailAddress()
     * @uses CustomerDetail::setPhoneNumber()
     * @uses CustomerDetail::setRelatedOrganizationName()
     * @uses CustomerDetail::setAddressStreet1()
     * @uses CustomerDetail::setAddressStreet2()
     * @uses CustomerDetail::setAddressCity()
     * @uses CustomerDetail::setAddressStateProvince()
     * @uses CustomerDetail::setAddressPostalCode()
     * @uses CustomerDetail::setAddressCountry()
     * @param bool $emailOptIn
     * @param string $firstName
     * @param string $lastName
     * @param string $emailAddress
     * @param string $phoneNumber
     * @param string $relatedOrganizationName
     * @param string $addressStreet1
     * @param string $addressStreet2
     * @param string $addressCity
     * @param string $addressStateProvince
     * @param string $addressPostalCode
     * @param string $addressCountry
     */
    public function __construct($emailOptIn = null, $firstName = null, $lastName = null, $emailAddress = null, $phoneNumber = null, $relatedOrganizationName = null, $addressStreet1 = null, $addressStreet2 = null, $addressCity = null, $addressStateProvince = null, $addressPostalCode = null, $addressCountry = null)
    {
        $this
            ->setEmailOptIn($emailOptIn)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setEmailAddress($emailAddress)
            ->setPhoneNumber($phoneNumber)
            ->setRelatedOrganizationName($relatedOrganizationName)
            ->setAddressStreet1($addressStreet1)
            ->setAddressStreet2($addressStreet2)
            ->setAddressCity($addressCity)
            ->setAddressStateProvince($addressStateProvince)
            ->setAddressPostalCode($addressPostalCode)
            ->setAddressCountry($addressCountry);
    }
    /**
     * Get EmailOptIn value
     * @return bool
     */
    public function getEmailOptIn()
    {
        return $this->EmailOptIn;
    }
    /**
     * Set EmailOptIn value
     * @param bool $emailOptIn
     * @return \StructType\CustomerDetail
     */
    public function setEmailOptIn($emailOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailOptIn) && !is_bool($emailOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($emailOptIn)), __LINE__);
        }
        $this->EmailOptIn = $emailOptIn;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\CustomerDetail
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\CustomerDetail
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\CustomerDetail
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\CustomerDetail
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get RelatedOrganizationName value
     * @return string|null
     */
    public function getRelatedOrganizationName()
    {
        return $this->RelatedOrganizationName;
    }
    /**
     * Set RelatedOrganizationName value
     * @param string $relatedOrganizationName
     * @return \StructType\CustomerDetail
     */
    public function setRelatedOrganizationName($relatedOrganizationName = null)
    {
        // validation for constraint: string
        if (!is_null($relatedOrganizationName) && !is_string($relatedOrganizationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relatedOrganizationName)), __LINE__);
        }
        $this->RelatedOrganizationName = $relatedOrganizationName;
        return $this;
    }
    /**
     * Get AddressStreet1 value
     * @return string|null
     */
    public function getAddressStreet1()
    {
        return $this->AddressStreet1;
    }
    /**
     * Set AddressStreet1 value
     * @param string $addressStreet1
     * @return \StructType\CustomerDetail
     */
    public function setAddressStreet1($addressStreet1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressStreet1) && !is_string($addressStreet1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStreet1)), __LINE__);
        }
        $this->AddressStreet1 = $addressStreet1;
        return $this;
    }
    /**
     * Get AddressStreet2 value
     * @return string|null
     */
    public function getAddressStreet2()
    {
        return $this->AddressStreet2;
    }
    /**
     * Set AddressStreet2 value
     * @param string $addressStreet2
     * @return \StructType\CustomerDetail
     */
    public function setAddressStreet2($addressStreet2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressStreet2) && !is_string($addressStreet2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStreet2)), __LINE__);
        }
        $this->AddressStreet2 = $addressStreet2;
        return $this;
    }
    /**
     * Get AddressCity value
     * @return string|null
     */
    public function getAddressCity()
    {
        return $this->AddressCity;
    }
    /**
     * Set AddressCity value
     * @param string $addressCity
     * @return \StructType\CustomerDetail
     */
    public function setAddressCity($addressCity = null)
    {
        // validation for constraint: string
        if (!is_null($addressCity) && !is_string($addressCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressCity)), __LINE__);
        }
        $this->AddressCity = $addressCity;
        return $this;
    }
    /**
     * Get AddressStateProvince value
     * @return string|null
     */
    public function getAddressStateProvince()
    {
        return $this->AddressStateProvince;
    }
    /**
     * Set AddressStateProvince value
     * @param string $addressStateProvince
     * @return \StructType\CustomerDetail
     */
    public function setAddressStateProvince($addressStateProvince = null)
    {
        // validation for constraint: string
        if (!is_null($addressStateProvince) && !is_string($addressStateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStateProvince)), __LINE__);
        }
        $this->AddressStateProvince = $addressStateProvince;
        return $this;
    }
    /**
     * Get AddressPostalCode value
     * @return string|null
     */
    public function getAddressPostalCode()
    {
        return $this->AddressPostalCode;
    }
    /**
     * Set AddressPostalCode value
     * @param string $addressPostalCode
     * @return \StructType\CustomerDetail
     */
    public function setAddressPostalCode($addressPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($addressPostalCode) && !is_string($addressPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressPostalCode)), __LINE__);
        }
        $this->AddressPostalCode = $addressPostalCode;
        return $this;
    }
    /**
     * Get AddressCountry value
     * @return string|null
     */
    public function getAddressCountry()
    {
        return $this->AddressCountry;
    }
    /**
     * Set AddressCountry value
     * @param string $addressCountry
     * @return \StructType\CustomerDetail
     */
    public function setAddressCountry($addressCountry = null)
    {
        // validation for constraint: string
        if (!is_null($addressCountry) && !is_string($addressCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressCountry)), __LINE__);
        }
        $this->AddressCountry = $addressCountry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
