<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardParameters StructType
 * @subpackage Structs
 */
class CreditCardParameters extends SubParameters
{
    /**
     * The CardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardNumber;
    /**
     * The ExpirationMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationMonth;
    /**
     * The ExpirationYear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationYear;
    /**
     * The NameOnCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameOnCard;
    /**
     * Constructor method for CreditCardParameters
     * @uses CreditCardParameters::setCardNumber()
     * @uses CreditCardParameters::setExpirationMonth()
     * @uses CreditCardParameters::setExpirationYear()
     * @uses CreditCardParameters::setNameOnCard()
     * @param string $cardNumber
     * @param string $expirationMonth
     * @param string $expirationYear
     * @param string $nameOnCard
     */
    public function __construct($cardNumber = null, $expirationMonth = null, $expirationYear = null, $nameOnCard = null)
    {
        $this
            ->setCardNumber($cardNumber)
            ->setExpirationMonth($expirationMonth)
            ->setExpirationYear($expirationYear)
            ->setNameOnCard($nameOnCard);
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\CreditCardParameters
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get ExpirationMonth value
     * @return string|null
     */
    public function getExpirationMonth()
    {
        return $this->ExpirationMonth;
    }
    /**
     * Set ExpirationMonth value
     * @param string $expirationMonth
     * @return \StructType\CreditCardParameters
     */
    public function setExpirationMonth($expirationMonth = null)
    {
        // validation for constraint: string
        if (!is_null($expirationMonth) && !is_string($expirationMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expirationMonth)), __LINE__);
        }
        $this->ExpirationMonth = $expirationMonth;
        return $this;
    }
    /**
     * Get ExpirationYear value
     * @return string|null
     */
    public function getExpirationYear()
    {
        return $this->ExpirationYear;
    }
    /**
     * Set ExpirationYear value
     * @param string $expirationYear
     * @return \StructType\CreditCardParameters
     */
    public function setExpirationYear($expirationYear = null)
    {
        // validation for constraint: string
        if (!is_null($expirationYear) && !is_string($expirationYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expirationYear)), __LINE__);
        }
        $this->ExpirationYear = $expirationYear;
        return $this;
    }
    /**
     * Get NameOnCard value
     * @return string|null
     */
    public function getNameOnCard()
    {
        return $this->NameOnCard;
    }
    /**
     * Set NameOnCard value
     * @param string $nameOnCard
     * @return \StructType\CreditCardParameters
     */
    public function setNameOnCard($nameOnCard = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnCard) && !is_string($nameOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameOnCard)), __LINE__);
        }
        $this->NameOnCard = $nameOnCard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditCardParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
