<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateWebsiteParameters StructType
 * @subpackage Structs
 */
class CreateWebsiteParameters extends CreateRecordParameters
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The PreferredWebsite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PreferredWebsite;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $Contact;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for CreateWebsiteParameters
     * @uses CreateWebsiteParameters::setActive()
     * @uses CreateWebsiteParameters::setPreferredWebsite()
     * @uses CreateWebsiteParameters::setContact()
     * @uses CreateWebsiteParameters::setURL()
     * @param bool $active
     * @param bool $preferredWebsite
     * @param \StructType\FindOrCreateContactParameters $contact
     * @param string $uRL
     */
    public function __construct($active = null, $preferredWebsite = null, \StructType\FindOrCreateContactParameters $contact = null, $uRL = null)
    {
        $this
            ->setActive($active)
            ->setPreferredWebsite($preferredWebsite)
            ->setContact($contact)
            ->setURL($uRL);
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\CreateWebsiteParameters
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get PreferredWebsite value
     * @return bool
     */
    public function getPreferredWebsite()
    {
        return $this->PreferredWebsite;
    }
    /**
     * Set PreferredWebsite value
     * @param bool $preferredWebsite
     * @return \StructType\CreateWebsiteParameters
     */
    public function setPreferredWebsite($preferredWebsite = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferredWebsite) && !is_bool($preferredWebsite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($preferredWebsite)), __LINE__);
        }
        $this->PreferredWebsite = $preferredWebsite;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\FindOrCreateContactParameters $contact
     * @return \StructType\CreateWebsiteParameters
     */
    public function setContact(\StructType\FindOrCreateContactParameters $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\CreateWebsiteParameters
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateWebsiteParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
