<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateSocialMediaHandleParameters StructType
 * @subpackage Structs
 */
class CreateSocialMediaHandleParameters extends CreateRecordParameters
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $Contact;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for CreateSocialMediaHandleParameters
     * @uses CreateSocialMediaHandleParameters::setType()
     * @uses CreateSocialMediaHandleParameters::setContact()
     * @uses CreateSocialMediaHandleParameters::setURL()
     * @param string $type
     * @param \StructType\FindOrCreateContactParameters $contact
     * @param string $uRL
     */
    public function __construct($type = null, \StructType\FindOrCreateContactParameters $contact = null, $uRL = null)
    {
        $this
            ->setType($type)
            ->setContact($contact)
            ->setURL($uRL);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\SocialNetworkTypes::valueIsValid()
     * @uses \EnumType\SocialNetworkTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\CreateSocialMediaHandleParameters
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SocialNetworkTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\SocialNetworkTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\FindOrCreateContactParameters $contact
     * @return \StructType\CreateSocialMediaHandleParameters
     */
    public function setContact(\StructType\FindOrCreateContactParameters $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\CreateSocialMediaHandleParameters
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateSocialMediaHandleParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
