<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePersonParameters StructType
 * @subpackage Structs
 */
class CreatePersonParameters extends CreateRecordParameters
{
    /**
     * The Prefix_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Prefix_Id;
    /**
     * The Suffix_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Suffix_Id;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The Gender
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The LanguagePreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LanguagePreference;
    /**
     * The MailOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $MailOptIn;
    /**
     * The EmailOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $EmailOptIn;
    /**
     * The PhoneOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PhoneOptIn;
    /**
     * The FaxOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $FaxOptIn;
    /**
     * The SmsOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SmsOptIn;
    /**
     * The SyncType_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SyncType_Id;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The AddressStreet1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStreet1;
    /**
     * The AddressStreet2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStreet2;
    /**
     * The AddressCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressCity;
    /**
     * The AddressState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressState;
    /**
     * The AddressPostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressPostalCode;
    /**
     * The AddressCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressCountry;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The Sms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sms;
    /**
     * The SyncExternalId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SyncExternalId;
    /**
     * The Groups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFindOrCreateGroupParameters
     */
    public $Groups;
    /**
     * The Tags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFindOrCreateTagParameters
     */
    public $Tags;
    /**
     * The OptInLists
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFindOrCreateOptInListParameters
     */
    public $OptInLists;
    /**
     * The CustomFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEditContactCustomFieldParameters
     */
    public $CustomFields;
    /**
     * Constructor method for CreatePersonParameters
     * @uses CreatePersonParameters::setPrefix_Id()
     * @uses CreatePersonParameters::setSuffix_Id()
     * @uses CreatePersonParameters::setBirthDate()
     * @uses CreatePersonParameters::setGender()
     * @uses CreatePersonParameters::setLanguagePreference()
     * @uses CreatePersonParameters::setMailOptIn()
     * @uses CreatePersonParameters::setEmailOptIn()
     * @uses CreatePersonParameters::setPhoneOptIn()
     * @uses CreatePersonParameters::setFaxOptIn()
     * @uses CreatePersonParameters::setSmsOptIn()
     * @uses CreatePersonParameters::setSyncType_Id()
     * @uses CreatePersonParameters::setFirstName()
     * @uses CreatePersonParameters::setMiddleName()
     * @uses CreatePersonParameters::setLastName()
     * @uses CreatePersonParameters::setAddressStreet1()
     * @uses CreatePersonParameters::setAddressStreet2()
     * @uses CreatePersonParameters::setAddressCity()
     * @uses CreatePersonParameters::setAddressState()
     * @uses CreatePersonParameters::setAddressPostalCode()
     * @uses CreatePersonParameters::setAddressCountry()
     * @uses CreatePersonParameters::setEmailAddress()
     * @uses CreatePersonParameters::setPhone()
     * @uses CreatePersonParameters::setFax()
     * @uses CreatePersonParameters::setSms()
     * @uses CreatePersonParameters::setSyncExternalId()
     * @uses CreatePersonParameters::setGroups()
     * @uses CreatePersonParameters::setTags()
     * @uses CreatePersonParameters::setOptInLists()
     * @uses CreatePersonParameters::setCustomFields()
     * @param int $prefix_Id
     * @param int $suffix_Id
     * @param string $birthDate
     * @param string $gender
     * @param string $languagePreference
     * @param bool $mailOptIn
     * @param bool $emailOptIn
     * @param bool $phoneOptIn
     * @param bool $faxOptIn
     * @param bool $smsOptIn
     * @param int $syncType_Id
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $addressStreet1
     * @param string $addressStreet2
     * @param string $addressCity
     * @param string $addressState
     * @param string $addressPostalCode
     * @param string $addressCountry
     * @param string $emailAddress
     * @param string $phone
     * @param string $fax
     * @param string $sms
     * @param string $syncExternalId
     * @param \ArrayType\ArrayOfFindOrCreateGroupParameters $groups
     * @param \ArrayType\ArrayOfFindOrCreateTagParameters $tags
     * @param \ArrayType\ArrayOfFindOrCreateOptInListParameters $optInLists
     * @param \ArrayType\ArrayOfEditContactCustomFieldParameters $customFields
     */
    public function __construct($prefix_Id = null, $suffix_Id = null, $birthDate = null, $gender = null, $languagePreference = null, $mailOptIn = null, $emailOptIn = null, $phoneOptIn = null, $faxOptIn = null, $smsOptIn = null, $syncType_Id = null, $firstName = null, $middleName = null, $lastName = null, $addressStreet1 = null, $addressStreet2 = null, $addressCity = null, $addressState = null, $addressPostalCode = null, $addressCountry = null, $emailAddress = null, $phone = null, $fax = null, $sms = null, $syncExternalId = null, \ArrayType\ArrayOfFindOrCreateGroupParameters $groups = null, \ArrayType\ArrayOfFindOrCreateTagParameters $tags = null, \ArrayType\ArrayOfFindOrCreateOptInListParameters $optInLists = null, \ArrayType\ArrayOfEditContactCustomFieldParameters $customFields = null)
    {
        $this
            ->setPrefix_Id($prefix_Id)
            ->setSuffix_Id($suffix_Id)
            ->setBirthDate($birthDate)
            ->setGender($gender)
            ->setLanguagePreference($languagePreference)
            ->setMailOptIn($mailOptIn)
            ->setEmailOptIn($emailOptIn)
            ->setPhoneOptIn($phoneOptIn)
            ->setFaxOptIn($faxOptIn)
            ->setSmsOptIn($smsOptIn)
            ->setSyncType_Id($syncType_Id)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setAddressStreet1($addressStreet1)
            ->setAddressStreet2($addressStreet2)
            ->setAddressCity($addressCity)
            ->setAddressState($addressState)
            ->setAddressPostalCode($addressPostalCode)
            ->setAddressCountry($addressCountry)
            ->setEmailAddress($emailAddress)
            ->setPhone($phone)
            ->setFax($fax)
            ->setSms($sms)
            ->setSyncExternalId($syncExternalId)
            ->setGroups($groups)
            ->setTags($tags)
            ->setOptInLists($optInLists)
            ->setCustomFields($customFields);
    }
    /**
     * Get Prefix_Id value
     * @return int
     */
    public function getPrefix_Id()
    {
        return $this->Prefix_Id;
    }
    /**
     * Set Prefix_Id value
     * @param int $prefix_Id
     * @return \StructType\CreatePersonParameters
     */
    public function setPrefix_Id($prefix_Id = null)
    {
        // validation for constraint: int
        if (!is_null($prefix_Id) && !is_numeric($prefix_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($prefix_Id)), __LINE__);
        }
        $this->Prefix_Id = $prefix_Id;
        return $this;
    }
    /**
     * Get Suffix_Id value
     * @return int
     */
    public function getSuffix_Id()
    {
        return $this->Suffix_Id;
    }
    /**
     * Set Suffix_Id value
     * @param int $suffix_Id
     * @return \StructType\CreatePersonParameters
     */
    public function setSuffix_Id($suffix_Id = null)
    {
        // validation for constraint: int
        if (!is_null($suffix_Id) && !is_numeric($suffix_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($suffix_Id)), __LINE__);
        }
        $this->Suffix_Id = $suffix_Id;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\CreatePersonParameters
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Gender value
     * @return string
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\Genders::valueIsValid()
     * @uses \EnumType\Genders::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\CreatePersonParameters
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Genders::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $gender, implode(', ', \EnumType\Genders::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get LanguagePreference value
     * @return string
     */
    public function getLanguagePreference()
    {
        return $this->LanguagePreference;
    }
    /**
     * Set LanguagePreference value
     * @uses \EnumType\LanguagePreferences::valueIsValid()
     * @uses \EnumType\LanguagePreferences::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $languagePreference
     * @return \StructType\CreatePersonParameters
     */
    public function setLanguagePreference($languagePreference = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LanguagePreferences::valueIsValid($languagePreference)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $languagePreference, implode(', ', \EnumType\LanguagePreferences::getValidValues())), __LINE__);
        }
        $this->LanguagePreference = $languagePreference;
        return $this;
    }
    /**
     * Get MailOptIn value
     * @return bool
     */
    public function getMailOptIn()
    {
        return $this->MailOptIn;
    }
    /**
     * Set MailOptIn value
     * @param bool $mailOptIn
     * @return \StructType\CreatePersonParameters
     */
    public function setMailOptIn($mailOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailOptIn) && !is_bool($mailOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mailOptIn)), __LINE__);
        }
        $this->MailOptIn = $mailOptIn;
        return $this;
    }
    /**
     * Get EmailOptIn value
     * @return bool
     */
    public function getEmailOptIn()
    {
        return $this->EmailOptIn;
    }
    /**
     * Set EmailOptIn value
     * @param bool $emailOptIn
     * @return \StructType\CreatePersonParameters
     */
    public function setEmailOptIn($emailOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailOptIn) && !is_bool($emailOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($emailOptIn)), __LINE__);
        }
        $this->EmailOptIn = $emailOptIn;
        return $this;
    }
    /**
     * Get PhoneOptIn value
     * @return bool
     */
    public function getPhoneOptIn()
    {
        return $this->PhoneOptIn;
    }
    /**
     * Set PhoneOptIn value
     * @param bool $phoneOptIn
     * @return \StructType\CreatePersonParameters
     */
    public function setPhoneOptIn($phoneOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneOptIn) && !is_bool($phoneOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($phoneOptIn)), __LINE__);
        }
        $this->PhoneOptIn = $phoneOptIn;
        return $this;
    }
    /**
     * Get FaxOptIn value
     * @return bool
     */
    public function getFaxOptIn()
    {
        return $this->FaxOptIn;
    }
    /**
     * Set FaxOptIn value
     * @param bool $faxOptIn
     * @return \StructType\CreatePersonParameters
     */
    public function setFaxOptIn($faxOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($faxOptIn) && !is_bool($faxOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($faxOptIn)), __LINE__);
        }
        $this->FaxOptIn = $faxOptIn;
        return $this;
    }
    /**
     * Get SmsOptIn value
     * @return bool
     */
    public function getSmsOptIn()
    {
        return $this->SmsOptIn;
    }
    /**
     * Set SmsOptIn value
     * @param bool $smsOptIn
     * @return \StructType\CreatePersonParameters
     */
    public function setSmsOptIn($smsOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($smsOptIn) && !is_bool($smsOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smsOptIn)), __LINE__);
        }
        $this->SmsOptIn = $smsOptIn;
        return $this;
    }
    /**
     * Get SyncType_Id value
     * @return int
     */
    public function getSyncType_Id()
    {
        return $this->SyncType_Id;
    }
    /**
     * Set SyncType_Id value
     * @param int $syncType_Id
     * @return \StructType\CreatePersonParameters
     */
    public function setSyncType_Id($syncType_Id = null)
    {
        // validation for constraint: int
        if (!is_null($syncType_Id) && !is_numeric($syncType_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($syncType_Id)), __LINE__);
        }
        $this->SyncType_Id = $syncType_Id;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\CreatePersonParameters
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\CreatePersonParameters
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\CreatePersonParameters
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get AddressStreet1 value
     * @return string|null
     */
    public function getAddressStreet1()
    {
        return $this->AddressStreet1;
    }
    /**
     * Set AddressStreet1 value
     * @param string $addressStreet1
     * @return \StructType\CreatePersonParameters
     */
    public function setAddressStreet1($addressStreet1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressStreet1) && !is_string($addressStreet1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStreet1)), __LINE__);
        }
        $this->AddressStreet1 = $addressStreet1;
        return $this;
    }
    /**
     * Get AddressStreet2 value
     * @return string|null
     */
    public function getAddressStreet2()
    {
        return $this->AddressStreet2;
    }
    /**
     * Set AddressStreet2 value
     * @param string $addressStreet2
     * @return \StructType\CreatePersonParameters
     */
    public function setAddressStreet2($addressStreet2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressStreet2) && !is_string($addressStreet2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStreet2)), __LINE__);
        }
        $this->AddressStreet2 = $addressStreet2;
        return $this;
    }
    /**
     * Get AddressCity value
     * @return string|null
     */
    public function getAddressCity()
    {
        return $this->AddressCity;
    }
    /**
     * Set AddressCity value
     * @param string $addressCity
     * @return \StructType\CreatePersonParameters
     */
    public function setAddressCity($addressCity = null)
    {
        // validation for constraint: string
        if (!is_null($addressCity) && !is_string($addressCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressCity)), __LINE__);
        }
        $this->AddressCity = $addressCity;
        return $this;
    }
    /**
     * Get AddressState value
     * @return string|null
     */
    public function getAddressState()
    {
        return $this->AddressState;
    }
    /**
     * Set AddressState value
     * @param string $addressState
     * @return \StructType\CreatePersonParameters
     */
    public function setAddressState($addressState = null)
    {
        // validation for constraint: string
        if (!is_null($addressState) && !is_string($addressState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressState)), __LINE__);
        }
        $this->AddressState = $addressState;
        return $this;
    }
    /**
     * Get AddressPostalCode value
     * @return string|null
     */
    public function getAddressPostalCode()
    {
        return $this->AddressPostalCode;
    }
    /**
     * Set AddressPostalCode value
     * @param string $addressPostalCode
     * @return \StructType\CreatePersonParameters
     */
    public function setAddressPostalCode($addressPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($addressPostalCode) && !is_string($addressPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressPostalCode)), __LINE__);
        }
        $this->AddressPostalCode = $addressPostalCode;
        return $this;
    }
    /**
     * Get AddressCountry value
     * @return string|null
     */
    public function getAddressCountry()
    {
        return $this->AddressCountry;
    }
    /**
     * Set AddressCountry value
     * @param string $addressCountry
     * @return \StructType\CreatePersonParameters
     */
    public function setAddressCountry($addressCountry = null)
    {
        // validation for constraint: string
        if (!is_null($addressCountry) && !is_string($addressCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressCountry)), __LINE__);
        }
        $this->AddressCountry = $addressCountry;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\CreatePersonParameters
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\CreatePersonParameters
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\CreatePersonParameters
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Sms value
     * @return string|null
     */
    public function getSms()
    {
        return $this->Sms;
    }
    /**
     * Set Sms value
     * @param string $sms
     * @return \StructType\CreatePersonParameters
     */
    public function setSms($sms = null)
    {
        // validation for constraint: string
        if (!is_null($sms) && !is_string($sms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sms)), __LINE__);
        }
        $this->Sms = $sms;
        return $this;
    }
    /**
     * Get SyncExternalId value
     * @return string|null
     */
    public function getSyncExternalId()
    {
        return $this->SyncExternalId;
    }
    /**
     * Set SyncExternalId value
     * @param string $syncExternalId
     * @return \StructType\CreatePersonParameters
     */
    public function setSyncExternalId($syncExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($syncExternalId) && !is_string($syncExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($syncExternalId)), __LINE__);
        }
        $this->SyncExternalId = $syncExternalId;
        return $this;
    }
    /**
     * Get Groups value
     * @return \ArrayType\ArrayOfFindOrCreateGroupParameters|null
     */
    public function getGroups()
    {
        return $this->Groups;
    }
    /**
     * Set Groups value
     * @param \ArrayType\ArrayOfFindOrCreateGroupParameters $groups
     * @return \StructType\CreatePersonParameters
     */
    public function setGroups(\ArrayType\ArrayOfFindOrCreateGroupParameters $groups = null)
    {
        $this->Groups = $groups;
        return $this;
    }
    /**
     * Get Tags value
     * @return \ArrayType\ArrayOfFindOrCreateTagParameters|null
     */
    public function getTags()
    {
        return $this->Tags;
    }
    /**
     * Set Tags value
     * @param \ArrayType\ArrayOfFindOrCreateTagParameters $tags
     * @return \StructType\CreatePersonParameters
     */
    public function setTags(\ArrayType\ArrayOfFindOrCreateTagParameters $tags = null)
    {
        $this->Tags = $tags;
        return $this;
    }
    /**
     * Get OptInLists value
     * @return \ArrayType\ArrayOfFindOrCreateOptInListParameters|null
     */
    public function getOptInLists()
    {
        return $this->OptInLists;
    }
    /**
     * Set OptInLists value
     * @param \ArrayType\ArrayOfFindOrCreateOptInListParameters $optInLists
     * @return \StructType\CreatePersonParameters
     */
    public function setOptInLists(\ArrayType\ArrayOfFindOrCreateOptInListParameters $optInLists = null)
    {
        $this->OptInLists = $optInLists;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \ArrayType\ArrayOfEditContactCustomFieldParameters|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \ArrayType\ArrayOfEditContactCustomFieldParameters $customFields
     * @return \StructType\CreatePersonParameters
     */
    public function setCustomFields(\ArrayType\ArrayOfEditContactCustomFieldParameters $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreatePersonParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
