<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateEmailAddressParameters StructType
 * @subpackage Structs
 */
class CreateEmailAddressParameters extends CreateRecordParameters
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The EmailOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $EmailOptIn;
    /**
     * The PreferredEmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PreferredEmailAddress;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $Contact;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * Constructor method for CreateEmailAddressParameters
     * @uses CreateEmailAddressParameters::setType()
     * @uses CreateEmailAddressParameters::setActive()
     * @uses CreateEmailAddressParameters::setEmailOptIn()
     * @uses CreateEmailAddressParameters::setPreferredEmailAddress()
     * @uses CreateEmailAddressParameters::setContact()
     * @uses CreateEmailAddressParameters::setEmailAddress()
     * @param string $type
     * @param bool $active
     * @param bool $emailOptIn
     * @param bool $preferredEmailAddress
     * @param \StructType\FindOrCreateContactParameters $contact
     * @param string $emailAddress
     */
    public function __construct($type = null, $active = null, $emailOptIn = null, $preferredEmailAddress = null, \StructType\FindOrCreateContactParameters $contact = null, $emailAddress = null)
    {
        $this
            ->setType($type)
            ->setActive($active)
            ->setEmailOptIn($emailOptIn)
            ->setPreferredEmailAddress($preferredEmailAddress)
            ->setContact($contact)
            ->setEmailAddress($emailAddress);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\EmailAddressTypes::valueIsValid()
     * @uses \EnumType\EmailAddressTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\CreateEmailAddressParameters
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmailAddressTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\EmailAddressTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\CreateEmailAddressParameters
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get EmailOptIn value
     * @return bool
     */
    public function getEmailOptIn()
    {
        return $this->EmailOptIn;
    }
    /**
     * Set EmailOptIn value
     * @param bool $emailOptIn
     * @return \StructType\CreateEmailAddressParameters
     */
    public function setEmailOptIn($emailOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailOptIn) && !is_bool($emailOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($emailOptIn)), __LINE__);
        }
        $this->EmailOptIn = $emailOptIn;
        return $this;
    }
    /**
     * Get PreferredEmailAddress value
     * @return bool
     */
    public function getPreferredEmailAddress()
    {
        return $this->PreferredEmailAddress;
    }
    /**
     * Set PreferredEmailAddress value
     * @param bool $preferredEmailAddress
     * @return \StructType\CreateEmailAddressParameters
     */
    public function setPreferredEmailAddress($preferredEmailAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferredEmailAddress) && !is_bool($preferredEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($preferredEmailAddress)), __LINE__);
        }
        $this->PreferredEmailAddress = $preferredEmailAddress;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\FindOrCreateContactParameters $contact
     * @return \StructType\CreateEmailAddressParameters
     */
    public function setContact(\StructType\FindOrCreateContactParameters $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\CreateEmailAddressParameters
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateEmailAddressParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
