<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactSummary StructType
 * @subpackage Structs
 */
class ContactSummary extends MetaDataRecord
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The EmailAddress
     * @var string
     */
    public $EmailAddress;
    /**
     * Constructor method for ContactSummary
     * @uses ContactSummary::setType()
     * @uses ContactSummary::setEmailAddress()
     * @param string $type
     * @param string $emailAddress
     */
    public function __construct($type = null, $emailAddress = null)
    {
        $this
            ->setType($type)
            ->setEmailAddress($emailAddress);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\ContactTypes::valueIsValid()
     * @uses \EnumType\ContactTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ContactSummary
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContactTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ContactTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\ContactSummary
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
