<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactRecord StructType
 * @subpackage Structs
 */
class ContactRecord extends NamedDataRecord
{
    /**
     * The ContactType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ContactType;
    /**
     * The HighestPreviousTransaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $HighestPreviousTransaction;
    /**
     * The TotalTransactionAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalTransactionAmount;
    /**
     * The FirstTransaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FirstTransaction;
    /**
     * The MostRecentTransaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MostRecentTransaction;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The ReceiveMail
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ReceiveMail;
    /**
     * The ReceiveEmail
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ReceiveEmail;
    /**
     * The ReceivePhoneCalls
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ReceivePhoneCalls;
    /**
     * The ReceiveSMS
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ReceiveSMS;
    /**
     * The ReceiveFax
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ReceiveFax;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactStatus
     */
    public $Status;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactPriority
     */
    public $Priority;
    /**
     * The Salutation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Salutation
     */
    public $Salutation;
    /**
     * The PersonDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonDetail
     */
    public $PersonDetail;
    /**
     * The OrganizationDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrganizationDetail
     */
    public $OrganizationDetail;
    /**
     * The HouseholdDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HouseholdDetail
     */
    public $HouseholdDetail;
    /**
     * The PrimaryAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressRecord
     */
    public $PrimaryAddress;
    /**
     * The PrimaryEmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EmailAddressRecord
     */
    public $PrimaryEmailAddress;
    /**
     * The PrimaryPhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PhoneNumberRecord
     */
    public $PrimaryPhoneNumber;
    /**
     * The PrimaryRelationship
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelatedContact
     */
    public $PrimaryRelationship;
    /**
     * The Solicitor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Solicitor;
    /**
     * The ResponseChannel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChannelDetail
     */
    public $ResponseChannel;
    /**
     * The AcquisitionInitiative
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InitiativeDetail
     */
    public $AcquisitionInitiative;
    /**
     * The SyncDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SyncReference
     */
    public $SyncDetail;
    /**
     * The Groups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfContactGroup
     */
    public $Groups;
    /**
     * The Tags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfContactTag
     */
    public $Tags;
    /**
     * The Lists
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfContactOptInList
     */
    public $Lists;
    /**
     * The CustomFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfContactCustomField
     */
    public $CustomFields;
    /**
     * Constructor method for ContactRecord
     * @uses ContactRecord::setContactType()
     * @uses ContactRecord::setHighestPreviousTransaction()
     * @uses ContactRecord::setTotalTransactionAmount()
     * @uses ContactRecord::setFirstTransaction()
     * @uses ContactRecord::setMostRecentTransaction()
     * @uses ContactRecord::setActive()
     * @uses ContactRecord::setReceiveMail()
     * @uses ContactRecord::setReceiveEmail()
     * @uses ContactRecord::setReceivePhoneCalls()
     * @uses ContactRecord::setReceiveSMS()
     * @uses ContactRecord::setReceiveFax()
     * @uses ContactRecord::setStatus()
     * @uses ContactRecord::setPriority()
     * @uses ContactRecord::setSalutation()
     * @uses ContactRecord::setPersonDetail()
     * @uses ContactRecord::setOrganizationDetail()
     * @uses ContactRecord::setHouseholdDetail()
     * @uses ContactRecord::setPrimaryAddress()
     * @uses ContactRecord::setPrimaryEmailAddress()
     * @uses ContactRecord::setPrimaryPhoneNumber()
     * @uses ContactRecord::setPrimaryRelationship()
     * @uses ContactRecord::setSolicitor()
     * @uses ContactRecord::setResponseChannel()
     * @uses ContactRecord::setAcquisitionInitiative()
     * @uses ContactRecord::setSyncDetail()
     * @uses ContactRecord::setGroups()
     * @uses ContactRecord::setTags()
     * @uses ContactRecord::setLists()
     * @uses ContactRecord::setCustomFields()
     * @param string $contactType
     * @param float $highestPreviousTransaction
     * @param float $totalTransactionAmount
     * @param string $firstTransaction
     * @param string $mostRecentTransaction
     * @param bool $active
     * @param bool $receiveMail
     * @param bool $receiveEmail
     * @param bool $receivePhoneCalls
     * @param bool $receiveSMS
     * @param bool $receiveFax
     * @param \StructType\ContactStatus $status
     * @param \StructType\ContactPriority $priority
     * @param \StructType\Salutation $salutation
     * @param \StructType\PersonDetail $personDetail
     * @param \StructType\OrganizationDetail $organizationDetail
     * @param \StructType\HouseholdDetail $householdDetail
     * @param \StructType\AddressRecord $primaryAddress
     * @param \StructType\EmailAddressRecord $primaryEmailAddress
     * @param \StructType\PhoneNumberRecord $primaryPhoneNumber
     * @param \StructType\RelatedContact $primaryRelationship
     * @param \StructType\ContactSummary $solicitor
     * @param \StructType\ChannelDetail $responseChannel
     * @param \StructType\InitiativeDetail $acquisitionInitiative
     * @param \StructType\SyncReference $syncDetail
     * @param \ArrayType\ArrayOfContactGroup $groups
     * @param \ArrayType\ArrayOfContactTag $tags
     * @param \ArrayType\ArrayOfContactOptInList $lists
     * @param \ArrayType\ArrayOfContactCustomField $customFields
     */
    public function __construct($contactType = null, $highestPreviousTransaction = null, $totalTransactionAmount = null, $firstTransaction = null, $mostRecentTransaction = null, $active = null, $receiveMail = null, $receiveEmail = null, $receivePhoneCalls = null, $receiveSMS = null, $receiveFax = null, \StructType\ContactStatus $status = null, \StructType\ContactPriority $priority = null, \StructType\Salutation $salutation = null, \StructType\PersonDetail $personDetail = null, \StructType\OrganizationDetail $organizationDetail = null, \StructType\HouseholdDetail $householdDetail = null, \StructType\AddressRecord $primaryAddress = null, \StructType\EmailAddressRecord $primaryEmailAddress = null, \StructType\PhoneNumberRecord $primaryPhoneNumber = null, \StructType\RelatedContact $primaryRelationship = null, \StructType\ContactSummary $solicitor = null, \StructType\ChannelDetail $responseChannel = null, \StructType\InitiativeDetail $acquisitionInitiative = null, \StructType\SyncReference $syncDetail = null, \ArrayType\ArrayOfContactGroup $groups = null, \ArrayType\ArrayOfContactTag $tags = null, \ArrayType\ArrayOfContactOptInList $lists = null, \ArrayType\ArrayOfContactCustomField $customFields = null)
    {
        $this
            ->setContactType($contactType)
            ->setHighestPreviousTransaction($highestPreviousTransaction)
            ->setTotalTransactionAmount($totalTransactionAmount)
            ->setFirstTransaction($firstTransaction)
            ->setMostRecentTransaction($mostRecentTransaction)
            ->setActive($active)
            ->setReceiveMail($receiveMail)
            ->setReceiveEmail($receiveEmail)
            ->setReceivePhoneCalls($receivePhoneCalls)
            ->setReceiveSMS($receiveSMS)
            ->setReceiveFax($receiveFax)
            ->setStatus($status)
            ->setPriority($priority)
            ->setSalutation($salutation)
            ->setPersonDetail($personDetail)
            ->setOrganizationDetail($organizationDetail)
            ->setHouseholdDetail($householdDetail)
            ->setPrimaryAddress($primaryAddress)
            ->setPrimaryEmailAddress($primaryEmailAddress)
            ->setPrimaryPhoneNumber($primaryPhoneNumber)
            ->setPrimaryRelationship($primaryRelationship)
            ->setSolicitor($solicitor)
            ->setResponseChannel($responseChannel)
            ->setAcquisitionInitiative($acquisitionInitiative)
            ->setSyncDetail($syncDetail)
            ->setGroups($groups)
            ->setTags($tags)
            ->setLists($lists)
            ->setCustomFields($customFields);
    }
    /**
     * Get ContactType value
     * @return string
     */
    public function getContactType()
    {
        return $this->ContactType;
    }
    /**
     * Set ContactType value
     * @uses \EnumType\ContactTypes::valueIsValid()
     * @uses \EnumType\ContactTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contactType
     * @return \StructType\ContactRecord
     */
    public function setContactType($contactType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContactTypes::valueIsValid($contactType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $contactType, implode(', ', \EnumType\ContactTypes::getValidValues())), __LINE__);
        }
        $this->ContactType = $contactType;
        return $this;
    }
    /**
     * Get HighestPreviousTransaction value
     * @return float
     */
    public function getHighestPreviousTransaction()
    {
        return $this->HighestPreviousTransaction;
    }
    /**
     * Set HighestPreviousTransaction value
     * @param float $highestPreviousTransaction
     * @return \StructType\ContactRecord
     */
    public function setHighestPreviousTransaction($highestPreviousTransaction = null)
    {
        $this->HighestPreviousTransaction = $highestPreviousTransaction;
        return $this;
    }
    /**
     * Get TotalTransactionAmount value
     * @return float
     */
    public function getTotalTransactionAmount()
    {
        return $this->TotalTransactionAmount;
    }
    /**
     * Set TotalTransactionAmount value
     * @param float $totalTransactionAmount
     * @return \StructType\ContactRecord
     */
    public function setTotalTransactionAmount($totalTransactionAmount = null)
    {
        $this->TotalTransactionAmount = $totalTransactionAmount;
        return $this;
    }
    /**
     * Get FirstTransaction value
     * @return string
     */
    public function getFirstTransaction()
    {
        return $this->FirstTransaction;
    }
    /**
     * Set FirstTransaction value
     * @param string $firstTransaction
     * @return \StructType\ContactRecord
     */
    public function setFirstTransaction($firstTransaction = null)
    {
        // validation for constraint: string
        if (!is_null($firstTransaction) && !is_string($firstTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstTransaction)), __LINE__);
        }
        $this->FirstTransaction = $firstTransaction;
        return $this;
    }
    /**
     * Get MostRecentTransaction value
     * @return string
     */
    public function getMostRecentTransaction()
    {
        return $this->MostRecentTransaction;
    }
    /**
     * Set MostRecentTransaction value
     * @param string $mostRecentTransaction
     * @return \StructType\ContactRecord
     */
    public function setMostRecentTransaction($mostRecentTransaction = null)
    {
        // validation for constraint: string
        if (!is_null($mostRecentTransaction) && !is_string($mostRecentTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mostRecentTransaction)), __LINE__);
        }
        $this->MostRecentTransaction = $mostRecentTransaction;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\ContactRecord
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get ReceiveMail value
     * @return bool
     */
    public function getReceiveMail()
    {
        return $this->ReceiveMail;
    }
    /**
     * Set ReceiveMail value
     * @param bool $receiveMail
     * @return \StructType\ContactRecord
     */
    public function setReceiveMail($receiveMail = null)
    {
        // validation for constraint: boolean
        if (!is_null($receiveMail) && !is_bool($receiveMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($receiveMail)), __LINE__);
        }
        $this->ReceiveMail = $receiveMail;
        return $this;
    }
    /**
     * Get ReceiveEmail value
     * @return bool
     */
    public function getReceiveEmail()
    {
        return $this->ReceiveEmail;
    }
    /**
     * Set ReceiveEmail value
     * @param bool $receiveEmail
     * @return \StructType\ContactRecord
     */
    public function setReceiveEmail($receiveEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($receiveEmail) && !is_bool($receiveEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($receiveEmail)), __LINE__);
        }
        $this->ReceiveEmail = $receiveEmail;
        return $this;
    }
    /**
     * Get ReceivePhoneCalls value
     * @return bool
     */
    public function getReceivePhoneCalls()
    {
        return $this->ReceivePhoneCalls;
    }
    /**
     * Set ReceivePhoneCalls value
     * @param bool $receivePhoneCalls
     * @return \StructType\ContactRecord
     */
    public function setReceivePhoneCalls($receivePhoneCalls = null)
    {
        // validation for constraint: boolean
        if (!is_null($receivePhoneCalls) && !is_bool($receivePhoneCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($receivePhoneCalls)), __LINE__);
        }
        $this->ReceivePhoneCalls = $receivePhoneCalls;
        return $this;
    }
    /**
     * Get ReceiveSMS value
     * @return bool
     */
    public function getReceiveSMS()
    {
        return $this->ReceiveSMS;
    }
    /**
     * Set ReceiveSMS value
     * @param bool $receiveSMS
     * @return \StructType\ContactRecord
     */
    public function setReceiveSMS($receiveSMS = null)
    {
        // validation for constraint: boolean
        if (!is_null($receiveSMS) && !is_bool($receiveSMS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($receiveSMS)), __LINE__);
        }
        $this->ReceiveSMS = $receiveSMS;
        return $this;
    }
    /**
     * Get ReceiveFax value
     * @return bool
     */
    public function getReceiveFax()
    {
        return $this->ReceiveFax;
    }
    /**
     * Set ReceiveFax value
     * @param bool $receiveFax
     * @return \StructType\ContactRecord
     */
    public function setReceiveFax($receiveFax = null)
    {
        // validation for constraint: boolean
        if (!is_null($receiveFax) && !is_bool($receiveFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($receiveFax)), __LINE__);
        }
        $this->ReceiveFax = $receiveFax;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\ContactStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\ContactStatus $status
     * @return \StructType\ContactRecord
     */
    public function setStatus(\StructType\ContactStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Priority value
     * @return \StructType\ContactPriority|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param \StructType\ContactPriority $priority
     * @return \StructType\ContactRecord
     */
    public function setPriority(\StructType\ContactPriority $priority = null)
    {
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Salutation value
     * @return \StructType\Salutation|null
     */
    public function getSalutation()
    {
        return $this->Salutation;
    }
    /**
     * Set Salutation value
     * @param \StructType\Salutation $salutation
     * @return \StructType\ContactRecord
     */
    public function setSalutation(\StructType\Salutation $salutation = null)
    {
        $this->Salutation = $salutation;
        return $this;
    }
    /**
     * Get PersonDetail value
     * @return \StructType\PersonDetail|null
     */
    public function getPersonDetail()
    {
        return $this->PersonDetail;
    }
    /**
     * Set PersonDetail value
     * @param \StructType\PersonDetail $personDetail
     * @return \StructType\ContactRecord
     */
    public function setPersonDetail(\StructType\PersonDetail $personDetail = null)
    {
        $this->PersonDetail = $personDetail;
        return $this;
    }
    /**
     * Get OrganizationDetail value
     * @return \StructType\OrganizationDetail|null
     */
    public function getOrganizationDetail()
    {
        return $this->OrganizationDetail;
    }
    /**
     * Set OrganizationDetail value
     * @param \StructType\OrganizationDetail $organizationDetail
     * @return \StructType\ContactRecord
     */
    public function setOrganizationDetail(\StructType\OrganizationDetail $organizationDetail = null)
    {
        $this->OrganizationDetail = $organizationDetail;
        return $this;
    }
    /**
     * Get HouseholdDetail value
     * @return \StructType\HouseholdDetail|null
     */
    public function getHouseholdDetail()
    {
        return $this->HouseholdDetail;
    }
    /**
     * Set HouseholdDetail value
     * @param \StructType\HouseholdDetail $householdDetail
     * @return \StructType\ContactRecord
     */
    public function setHouseholdDetail(\StructType\HouseholdDetail $householdDetail = null)
    {
        $this->HouseholdDetail = $householdDetail;
        return $this;
    }
    /**
     * Get PrimaryAddress value
     * @return \StructType\AddressRecord|null
     */
    public function getPrimaryAddress()
    {
        return $this->PrimaryAddress;
    }
    /**
     * Set PrimaryAddress value
     * @param \StructType\AddressRecord $primaryAddress
     * @return \StructType\ContactRecord
     */
    public function setPrimaryAddress(\StructType\AddressRecord $primaryAddress = null)
    {
        $this->PrimaryAddress = $primaryAddress;
        return $this;
    }
    /**
     * Get PrimaryEmailAddress value
     * @return \StructType\EmailAddressRecord|null
     */
    public function getPrimaryEmailAddress()
    {
        return $this->PrimaryEmailAddress;
    }
    /**
     * Set PrimaryEmailAddress value
     * @param \StructType\EmailAddressRecord $primaryEmailAddress
     * @return \StructType\ContactRecord
     */
    public function setPrimaryEmailAddress(\StructType\EmailAddressRecord $primaryEmailAddress = null)
    {
        $this->PrimaryEmailAddress = $primaryEmailAddress;
        return $this;
    }
    /**
     * Get PrimaryPhoneNumber value
     * @return \StructType\PhoneNumberRecord|null
     */
    public function getPrimaryPhoneNumber()
    {
        return $this->PrimaryPhoneNumber;
    }
    /**
     * Set PrimaryPhoneNumber value
     * @param \StructType\PhoneNumberRecord $primaryPhoneNumber
     * @return \StructType\ContactRecord
     */
    public function setPrimaryPhoneNumber(\StructType\PhoneNumberRecord $primaryPhoneNumber = null)
    {
        $this->PrimaryPhoneNumber = $primaryPhoneNumber;
        return $this;
    }
    /**
     * Get PrimaryRelationship value
     * @return \StructType\RelatedContact|null
     */
    public function getPrimaryRelationship()
    {
        return $this->PrimaryRelationship;
    }
    /**
     * Set PrimaryRelationship value
     * @param \StructType\RelatedContact $primaryRelationship
     * @return \StructType\ContactRecord
     */
    public function setPrimaryRelationship(\StructType\RelatedContact $primaryRelationship = null)
    {
        $this->PrimaryRelationship = $primaryRelationship;
        return $this;
    }
    /**
     * Get Solicitor value
     * @return \StructType\ContactSummary|null
     */
    public function getSolicitor()
    {
        return $this->Solicitor;
    }
    /**
     * Set Solicitor value
     * @param \StructType\ContactSummary $solicitor
     * @return \StructType\ContactRecord
     */
    public function setSolicitor(\StructType\ContactSummary $solicitor = null)
    {
        $this->Solicitor = $solicitor;
        return $this;
    }
    /**
     * Get ResponseChannel value
     * @return \StructType\ChannelDetail|null
     */
    public function getResponseChannel()
    {
        return $this->ResponseChannel;
    }
    /**
     * Set ResponseChannel value
     * @param \StructType\ChannelDetail $responseChannel
     * @return \StructType\ContactRecord
     */
    public function setResponseChannel(\StructType\ChannelDetail $responseChannel = null)
    {
        $this->ResponseChannel = $responseChannel;
        return $this;
    }
    /**
     * Get AcquisitionInitiative value
     * @return \StructType\InitiativeDetail|null
     */
    public function getAcquisitionInitiative()
    {
        return $this->AcquisitionInitiative;
    }
    /**
     * Set AcquisitionInitiative value
     * @param \StructType\InitiativeDetail $acquisitionInitiative
     * @return \StructType\ContactRecord
     */
    public function setAcquisitionInitiative(\StructType\InitiativeDetail $acquisitionInitiative = null)
    {
        $this->AcquisitionInitiative = $acquisitionInitiative;
        return $this;
    }
    /**
     * Get SyncDetail value
     * @return \StructType\SyncReference|null
     */
    public function getSyncDetail()
    {
        return $this->SyncDetail;
    }
    /**
     * Set SyncDetail value
     * @param \StructType\SyncReference $syncDetail
     * @return \StructType\ContactRecord
     */
    public function setSyncDetail(\StructType\SyncReference $syncDetail = null)
    {
        $this->SyncDetail = $syncDetail;
        return $this;
    }
    /**
     * Get Groups value
     * @return \ArrayType\ArrayOfContactGroup|null
     */
    public function getGroups()
    {
        return $this->Groups;
    }
    /**
     * Set Groups value
     * @param \ArrayType\ArrayOfContactGroup $groups
     * @return \StructType\ContactRecord
     */
    public function setGroups(\ArrayType\ArrayOfContactGroup $groups = null)
    {
        $this->Groups = $groups;
        return $this;
    }
    /**
     * Get Tags value
     * @return \ArrayType\ArrayOfContactTag|null
     */
    public function getTags()
    {
        return $this->Tags;
    }
    /**
     * Set Tags value
     * @param \ArrayType\ArrayOfContactTag $tags
     * @return \StructType\ContactRecord
     */
    public function setTags(\ArrayType\ArrayOfContactTag $tags = null)
    {
        $this->Tags = $tags;
        return $this;
    }
    /**
     * Get Lists value
     * @return \ArrayType\ArrayOfContactOptInList|null
     */
    public function getLists()
    {
        return $this->Lists;
    }
    /**
     * Set Lists value
     * @param \ArrayType\ArrayOfContactOptInList $lists
     * @return \StructType\ContactRecord
     */
    public function setLists(\ArrayType\ArrayOfContactOptInList $lists = null)
    {
        $this->Lists = $lists;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \ArrayType\ArrayOfContactCustomField|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \ArrayType\ArrayOfContactCustomField $customFields
     * @return \StructType\ContactRecord
     */
    public function setCustomFields(\ArrayType\ArrayOfContactCustomField $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
