<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactOptInList StructType
 * @subpackage Structs
 */
class ContactOptInList extends DependentOneToManyRecord
{
    /**
     * The DateOptedOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateOptedOut;
    /**
     * The DateOptedIn
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DateOptedIn;
    /**
     * The List
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OptInList
     */
    public $List;
    /**
     * Constructor method for ContactOptInList
     * @uses ContactOptInList::setDateOptedOut()
     * @uses ContactOptInList::setDateOptedIn()
     * @uses ContactOptInList::setList()
     * @param string $dateOptedOut
     * @param string $dateOptedIn
     * @param \StructType\OptInList $list
     */
    public function __construct($dateOptedOut = null, $dateOptedIn = null, \StructType\OptInList $list = null)
    {
        $this
            ->setDateOptedOut($dateOptedOut)
            ->setDateOptedIn($dateOptedIn)
            ->setList($list);
    }
    /**
     * Get DateOptedOut value
     * @return string
     */
    public function getDateOptedOut()
    {
        return $this->DateOptedOut;
    }
    /**
     * Set DateOptedOut value
     * @param string $dateOptedOut
     * @return \StructType\ContactOptInList
     */
    public function setDateOptedOut($dateOptedOut = null)
    {
        // validation for constraint: string
        if (!is_null($dateOptedOut) && !is_string($dateOptedOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOptedOut)), __LINE__);
        }
        $this->DateOptedOut = $dateOptedOut;
        return $this;
    }
    /**
     * Get DateOptedIn value
     * @return string
     */
    public function getDateOptedIn()
    {
        return $this->DateOptedIn;
    }
    /**
     * Set DateOptedIn value
     * @param string $dateOptedIn
     * @return \StructType\ContactOptInList
     */
    public function setDateOptedIn($dateOptedIn = null)
    {
        // validation for constraint: string
        if (!is_null($dateOptedIn) && !is_string($dateOptedIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOptedIn)), __LINE__);
        }
        $this->DateOptedIn = $dateOptedIn;
        return $this;
    }
    /**
     * Get List value
     * @return \StructType\OptInList|null
     */
    public function getList()
    {
        return $this->List;
    }
    /**
     * Set List value
     * @param \StructType\OptInList $list
     * @return \StructType\ContactOptInList
     */
    public function setList(\StructType\OptInList $list = null)
    {
        $this->List = $list;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactOptInList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
