<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AudienceCollection StructType
 * @subpackage Structs
 */
class AudienceCollection extends GroupedProperties
{
    /**
     * The GrossSize
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $GrossSize;
    /**
     * The NetSize
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $NetSize;
    /**
     * Constructor method for AudienceCollection
     * @uses AudienceCollection::setGrossSize()
     * @uses AudienceCollection::setNetSize()
     * @param int $grossSize
     * @param int $netSize
     */
    public function __construct($grossSize = null, $netSize = null)
    {
        $this
            ->setGrossSize($grossSize)
            ->setNetSize($netSize);
    }
    /**
     * Get GrossSize value
     * @return int
     */
    public function getGrossSize()
    {
        return $this->GrossSize;
    }
    /**
     * Set GrossSize value
     * @param int $grossSize
     * @return \StructType\AudienceCollection
     */
    public function setGrossSize($grossSize = null)
    {
        // validation for constraint: int
        if (!is_null($grossSize) && !is_numeric($grossSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($grossSize)), __LINE__);
        }
        $this->GrossSize = $grossSize;
        return $this;
    }
    /**
     * Get NetSize value
     * @return int
     */
    public function getNetSize()
    {
        return $this->NetSize;
    }
    /**
     * Set NetSize value
     * @param int $netSize
     * @return \StructType\AudienceCollection
     */
    public function setNetSize($netSize = null)
    {
        // validation for constraint: int
        if (!is_null($netSize) && !is_numeric($netSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($netSize)), __LINE__);
        }
        $this->NetSize = $netSize;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AudienceCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
