<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributionInfoCollection StructType
 * @subpackage Structs
 */
class AttributionInfoCollection extends GroupedProperties
{
    /**
     * The Fund_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Fund_Id;
    /**
     * The Tribute_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Tribute_Id;
    /**
     * The GeneralLedgerCode_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $GeneralLedgerCode_Id;
    /**
     * The ResponseChannel_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ResponseChannel_Id;
    /**
     * The Initiative_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Initiative_Id;
    /**
     * The InitiativeSegment_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $InitiativeSegment_Id;
    /**
     * The Opportunity_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Opportunity_Id;
    /**
     * The Solicitor_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Solicitor_Id;
    /**
     * The Event_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Event_Id;
    /**
     * The PeerToPeerMicrosite_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PeerToPeerMicrosite_Id;
    /**
     * The PeerToPeerPage_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PeerToPeerPage_Id;
    /**
     * The PeerToPeerTeam_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PeerToPeerTeam_Id;
    /**
     * The GrassrootEvent_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $GrassrootEvent_Id;
    /**
     * The TrackingCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomCodesCollection
     */
    public $TrackingCodes;
    /**
     * Constructor method for AttributionInfoCollection
     * @uses AttributionInfoCollection::setFund_Id()
     * @uses AttributionInfoCollection::setTribute_Id()
     * @uses AttributionInfoCollection::setGeneralLedgerCode_Id()
     * @uses AttributionInfoCollection::setResponseChannel_Id()
     * @uses AttributionInfoCollection::setInitiative_Id()
     * @uses AttributionInfoCollection::setInitiativeSegment_Id()
     * @uses AttributionInfoCollection::setOpportunity_Id()
     * @uses AttributionInfoCollection::setSolicitor_Id()
     * @uses AttributionInfoCollection::setEvent_Id()
     * @uses AttributionInfoCollection::setPeerToPeerMicrosite_Id()
     * @uses AttributionInfoCollection::setPeerToPeerPage_Id()
     * @uses AttributionInfoCollection::setPeerToPeerTeam_Id()
     * @uses AttributionInfoCollection::setGrassrootEvent_Id()
     * @uses AttributionInfoCollection::setTrackingCodes()
     * @param int $fund_Id
     * @param int $tribute_Id
     * @param int $generalLedgerCode_Id
     * @param int $responseChannel_Id
     * @param int $initiative_Id
     * @param int $initiativeSegment_Id
     * @param int $opportunity_Id
     * @param int $solicitor_Id
     * @param int $event_Id
     * @param int $peerToPeerMicrosite_Id
     * @param int $peerToPeerPage_Id
     * @param int $peerToPeerTeam_Id
     * @param int $grassrootEvent_Id
     * @param \StructType\CustomCodesCollection $trackingCodes
     */
    public function __construct($fund_Id = null, $tribute_Id = null, $generalLedgerCode_Id = null, $responseChannel_Id = null, $initiative_Id = null, $initiativeSegment_Id = null, $opportunity_Id = null, $solicitor_Id = null, $event_Id = null, $peerToPeerMicrosite_Id = null, $peerToPeerPage_Id = null, $peerToPeerTeam_Id = null, $grassrootEvent_Id = null, \StructType\CustomCodesCollection $trackingCodes = null)
    {
        $this
            ->setFund_Id($fund_Id)
            ->setTribute_Id($tribute_Id)
            ->setGeneralLedgerCode_Id($generalLedgerCode_Id)
            ->setResponseChannel_Id($responseChannel_Id)
            ->setInitiative_Id($initiative_Id)
            ->setInitiativeSegment_Id($initiativeSegment_Id)
            ->setOpportunity_Id($opportunity_Id)
            ->setSolicitor_Id($solicitor_Id)
            ->setEvent_Id($event_Id)
            ->setPeerToPeerMicrosite_Id($peerToPeerMicrosite_Id)
            ->setPeerToPeerPage_Id($peerToPeerPage_Id)
            ->setPeerToPeerTeam_Id($peerToPeerTeam_Id)
            ->setGrassrootEvent_Id($grassrootEvent_Id)
            ->setTrackingCodes($trackingCodes);
    }
    /**
     * Get Fund_Id value
     * @return int
     */
    public function getFund_Id()
    {
        return $this->Fund_Id;
    }
    /**
     * Set Fund_Id value
     * @param int $fund_Id
     * @return \StructType\AttributionInfoCollection
     */
    public function setFund_Id($fund_Id = null)
    {
        // validation for constraint: int
        if (!is_null($fund_Id) && !is_numeric($fund_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fund_Id)), __LINE__);
        }
        $this->Fund_Id = $fund_Id;
        return $this;
    }
    /**
     * Get Tribute_Id value
     * @return int
     */
    public function getTribute_Id()
    {
        return $this->Tribute_Id;
    }
    /**
     * Set Tribute_Id value
     * @param int $tribute_Id
     * @return \StructType\AttributionInfoCollection
     */
    public function setTribute_Id($tribute_Id = null)
    {
        // validation for constraint: int
        if (!is_null($tribute_Id) && !is_numeric($tribute_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tribute_Id)), __LINE__);
        }
        $this->Tribute_Id = $tribute_Id;
        return $this;
    }
    /**
     * Get GeneralLedgerCode_Id value
     * @return int
     */
    public function getGeneralLedgerCode_Id()
    {
        return $this->GeneralLedgerCode_Id;
    }
    /**
     * Set GeneralLedgerCode_Id value
     * @param int $generalLedgerCode_Id
     * @return \StructType\AttributionInfoCollection
     */
    public function setGeneralLedgerCode_Id($generalLedgerCode_Id = null)
    {
        // validation for constraint: int
        if (!is_null($generalLedgerCode_Id) && !is_numeric($generalLedgerCode_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($generalLedgerCode_Id)), __LINE__);
        }
        $this->GeneralLedgerCode_Id = $generalLedgerCode_Id;
        return $this;
    }
    /**
     * Get ResponseChannel_Id value
     * @return int
     */
    public function getResponseChannel_Id()
    {
        return $this->ResponseChannel_Id;
    }
    /**
     * Set ResponseChannel_Id value
     * @param int $responseChannel_Id
     * @return \StructType\AttributionInfoCollection
     */
    public function setResponseChannel_Id($responseChannel_Id = null)
    {
        // validation for constraint: int
        if (!is_null($responseChannel_Id) && !is_numeric($responseChannel_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responseChannel_Id)), __LINE__);
        }
        $this->ResponseChannel_Id = $responseChannel_Id;
        return $this;
    }
    /**
     * Get Initiative_Id value
     * @return int
     */
    public function getInitiative_Id()
    {
        return $this->Initiative_Id;
    }
    /**
     * Set Initiative_Id value
     * @param int $initiative_Id
     * @return \StructType\AttributionInfoCollection
     */
    public function setInitiative_Id($initiative_Id = null)
    {
        // validation for constraint: int
        if (!is_null($initiative_Id) && !is_numeric($initiative_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($initiative_Id)), __LINE__);
        }
        $this->Initiative_Id = $initiative_Id;
        return $this;
    }
    /**
     * Get InitiativeSegment_Id value
     * @return int
     */
    public function getInitiativeSegment_Id()
    {
        return $this->InitiativeSegment_Id;
    }
    /**
     * Set InitiativeSegment_Id value
     * @param int $initiativeSegment_Id
     * @return \StructType\AttributionInfoCollection
     */
    public function setInitiativeSegment_Id($initiativeSegment_Id = null)
    {
        // validation for constraint: int
        if (!is_null($initiativeSegment_Id) && !is_numeric($initiativeSegment_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($initiativeSegment_Id)), __LINE__);
        }
        $this->InitiativeSegment_Id = $initiativeSegment_Id;
        return $this;
    }
    /**
     * Get Opportunity_Id value
     * @return int
     */
    public function getOpportunity_Id()
    {
        return $this->Opportunity_Id;
    }
    /**
     * Set Opportunity_Id value
     * @param int $opportunity_Id
     * @return \StructType\AttributionInfoCollection
     */
    public function setOpportunity_Id($opportunity_Id = null)
    {
        // validation for constraint: int
        if (!is_null($opportunity_Id) && !is_numeric($opportunity_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($opportunity_Id)), __LINE__);
        }
        $this->Opportunity_Id = $opportunity_Id;
        return $this;
    }
    /**
     * Get Solicitor_Id value
     * @return int
     */
    public function getSolicitor_Id()
    {
        return $this->Solicitor_Id;
    }
    /**
     * Set Solicitor_Id value
     * @param int $solicitor_Id
     * @return \StructType\AttributionInfoCollection
     */
    public function setSolicitor_Id($solicitor_Id = null)
    {
        // validation for constraint: int
        if (!is_null($solicitor_Id) && !is_numeric($solicitor_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($solicitor_Id)), __LINE__);
        }
        $this->Solicitor_Id = $solicitor_Id;
        return $this;
    }
    /**
     * Get Event_Id value
     * @return int
     */
    public function getEvent_Id()
    {
        return $this->Event_Id;
    }
    /**
     * Set Event_Id value
     * @param int $event_Id
     * @return \StructType\AttributionInfoCollection
     */
    public function setEvent_Id($event_Id = null)
    {
        // validation for constraint: int
        if (!is_null($event_Id) && !is_numeric($event_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($event_Id)), __LINE__);
        }
        $this->Event_Id = $event_Id;
        return $this;
    }
    /**
     * Get PeerToPeerMicrosite_Id value
     * @return int
     */
    public function getPeerToPeerMicrosite_Id()
    {
        return $this->PeerToPeerMicrosite_Id;
    }
    /**
     * Set PeerToPeerMicrosite_Id value
     * @param int $peerToPeerMicrosite_Id
     * @return \StructType\AttributionInfoCollection
     */
    public function setPeerToPeerMicrosite_Id($peerToPeerMicrosite_Id = null)
    {
        // validation for constraint: int
        if (!is_null($peerToPeerMicrosite_Id) && !is_numeric($peerToPeerMicrosite_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($peerToPeerMicrosite_Id)), __LINE__);
        }
        $this->PeerToPeerMicrosite_Id = $peerToPeerMicrosite_Id;
        return $this;
    }
    /**
     * Get PeerToPeerPage_Id value
     * @return int
     */
    public function getPeerToPeerPage_Id()
    {
        return $this->PeerToPeerPage_Id;
    }
    /**
     * Set PeerToPeerPage_Id value
     * @param int $peerToPeerPage_Id
     * @return \StructType\AttributionInfoCollection
     */
    public function setPeerToPeerPage_Id($peerToPeerPage_Id = null)
    {
        // validation for constraint: int
        if (!is_null($peerToPeerPage_Id) && !is_numeric($peerToPeerPage_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($peerToPeerPage_Id)), __LINE__);
        }
        $this->PeerToPeerPage_Id = $peerToPeerPage_Id;
        return $this;
    }
    /**
     * Get PeerToPeerTeam_Id value
     * @return int
     */
    public function getPeerToPeerTeam_Id()
    {
        return $this->PeerToPeerTeam_Id;
    }
    /**
     * Set PeerToPeerTeam_Id value
     * @param int $peerToPeerTeam_Id
     * @return \StructType\AttributionInfoCollection
     */
    public function setPeerToPeerTeam_Id($peerToPeerTeam_Id = null)
    {
        // validation for constraint: int
        if (!is_null($peerToPeerTeam_Id) && !is_numeric($peerToPeerTeam_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($peerToPeerTeam_Id)), __LINE__);
        }
        $this->PeerToPeerTeam_Id = $peerToPeerTeam_Id;
        return $this;
    }
    /**
     * Get GrassrootEvent_Id value
     * @return int
     */
    public function getGrassrootEvent_Id()
    {
        return $this->GrassrootEvent_Id;
    }
    /**
     * Set GrassrootEvent_Id value
     * @param int $grassrootEvent_Id
     * @return \StructType\AttributionInfoCollection
     */
    public function setGrassrootEvent_Id($grassrootEvent_Id = null)
    {
        // validation for constraint: int
        if (!is_null($grassrootEvent_Id) && !is_numeric($grassrootEvent_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($grassrootEvent_Id)), __LINE__);
        }
        $this->GrassrootEvent_Id = $grassrootEvent_Id;
        return $this;
    }
    /**
     * Get TrackingCodes value
     * @return \StructType\CustomCodesCollection|null
     */
    public function getTrackingCodes()
    {
        return $this->TrackingCodes;
    }
    /**
     * Set TrackingCodes value
     * @param \StructType\CustomCodesCollection $trackingCodes
     * @return \StructType\AttributionInfoCollection
     */
    public function setTrackingCodes(\StructType\CustomCodesCollection $trackingCodes = null)
    {
        $this->TrackingCodes = $trackingCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttributionInfoCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
