<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Re ServiceType
 * @subpackage Services
 */
class Re extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReRunDataJobs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReRunDataJobs $parameters
     * @return \StructType\ReRunDataJobsResponse|bool
     */
    public function ReRunDataJobs(\StructType\ReRunDataJobs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReRunDataJobs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReRunDataJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReRunDataJob $parameters
     * @return \StructType\ReRunDataJobResponse|bool
     */
    public function ReRunDataJob(\StructType\ReRunDataJob $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReRunDataJob($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReRunDataJobResponse|\StructType\ReRunDataJobsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
