<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Charge ServiceType
 * @subpackage Services
 */
class Charge extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ChargeContactPaymentProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChargeContactPaymentProfiles $parameters
     * @return \StructType\ChargeContactPaymentProfilesResponse|bool
     */
    public function ChargeContactPaymentProfiles(\StructType\ChargeContactPaymentProfiles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ChargeContactPaymentProfiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChargeContactPaymentProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChargeContactPaymentProfile $parameters
     * @return \StructType\ChargeContactPaymentProfileResponse|bool
     */
    public function ChargeContactPaymentProfile(\StructType\ChargeContactPaymentProfile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ChargeContactPaymentProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChargeCreditCards
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChargeCreditCards $parameters
     * @return \StructType\ChargeCreditCardsResponse|bool
     */
    public function ChargeCreditCards(\StructType\ChargeCreditCards $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ChargeCreditCards($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChargeCreditCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChargeCreditCard $parameters
     * @return \StructType\ChargeCreditCardResponse|bool
     */
    public function ChargeCreditCard(\StructType\ChargeCreditCard $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ChargeCreditCard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ChargeContactPaymentProfileResponse|\StructType\ChargeContactPaymentProfilesResponse|\StructType\ChargeCreditCardResponse|\StructType\ChargeCreditCardsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
