<?php

namespace EnumType;

/**
 * This class stands for ValidationMessageTypes EnumType
 * @subpackage Enumerations
 */
class ValidationMessageTypes
{
    /**
     * Constant for value 'Informational'
     * @return string 'Informational'
     */
    const VALUE_INFORMATIONAL = 'Informational';
    /**
     * Constant for value 'Critical'
     * @return string 'Critical'
     */
    const VALUE_CRITICAL = 'Critical';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INFORMATIONAL
     * @uses self::VALUE_CRITICAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INFORMATIONAL,
            self::VALUE_CRITICAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
