<?php

namespace EnumType;

/**
 * This class stands for SustainerAttributionModes EnumType
 * @subpackage Enumerations
 */
class SustainerAttributionModes
{
    /**
     * Constant for value 'AccountOnly'
     * @return string 'AccountOnly'
     */
    const VALUE_ACCOUNT_ONLY = 'AccountOnly';
    /**
     * Constant for value 'StateChangeOnly'
     * @return string 'StateChangeOnly'
     */
    const VALUE_STATE_CHANGE_ONLY = 'StateChangeOnly';
    /**
     * Constant for value 'AccountAndStateChange'
     * @return string 'AccountAndStateChange'
     */
    const VALUE_ACCOUNT_AND_STATE_CHANGE = 'AccountAndStateChange';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_ONLY
     * @uses self::VALUE_STATE_CHANGE_ONLY
     * @uses self::VALUE_ACCOUNT_AND_STATE_CHANGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_ONLY,
            self::VALUE_STATE_CHANGE_ONLY,
            self::VALUE_ACCOUNT_AND_STATE_CHANGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
