<?php

namespace EnumType;

/**
 * This class stands for SocialNetworkTypes EnumType
 * @subpackage Enumerations
 */
class SocialNetworkTypes
{
    /**
     * Constant for value 'Facebook'
     * @return string 'Facebook'
     */
    const VALUE_FACEBOOK = 'Facebook';
    /**
     * Constant for value 'LinkedIn'
     * @return string 'LinkedIn'
     */
    const VALUE_LINKED_IN = 'LinkedIn';
    /**
     * Constant for value 'Twitter'
     * @return string 'Twitter'
     */
    const VALUE_TWITTER = 'Twitter';
    /**
     * Constant for value 'Microsoft'
     * @return string 'Microsoft'
     */
    const VALUE_MICROSOFT = 'Microsoft';
    /**
     * Constant for value 'Google'
     * @return string 'Google'
     */
    const VALUE_GOOGLE = 'Google';
    /**
     * Constant for value 'Yahoo'
     * @return string 'Yahoo'
     */
    const VALUE_YAHOO = 'Yahoo';
    /**
     * Constant for value 'Pinterest'
     * @return string 'Pinterest'
     */
    const VALUE_PINTEREST = 'Pinterest';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FACEBOOK
     * @uses self::VALUE_LINKED_IN
     * @uses self::VALUE_TWITTER
     * @uses self::VALUE_MICROSOFT
     * @uses self::VALUE_GOOGLE
     * @uses self::VALUE_YAHOO
     * @uses self::VALUE_PINTEREST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FACEBOOK,
            self::VALUE_LINKED_IN,
            self::VALUE_TWITTER,
            self::VALUE_MICROSOFT,
            self::VALUE_GOOGLE,
            self::VALUE_YAHOO,
            self::VALUE_PINTEREST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
