<?php

namespace EnumType;

/**
 * This class stands for QueryTypes EnumType
 * @subpackage Enumerations
 */
class QueryTypes
{
    /**
     * Constant for value 'Summary'
     * @return string 'Summary'
     */
    const VALUE_SUMMARY = 'Summary';
    /**
     * Constant for value 'Detail'
     * @return string 'Detail'
     */
    const VALUE_DETAIL = 'Detail';
    /**
     * Constant for value 'Full'
     * @return string 'Full'
     */
    const VALUE_FULL = 'Full';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUMMARY
     * @uses self::VALUE_DETAIL
     * @uses self::VALUE_FULL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUMMARY,
            self::VALUE_DETAIL,
            self::VALUE_FULL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
