<?php

namespace EnumType;

/**
 * This class stands for PaymentMethods EnumType
 * @subpackage Enumerations
 */
class PaymentMethods
{
    /**
     * Constant for value 'CreditCard'
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Constant for value 'ACH'
     * @return string 'ACH'
     */
    const VALUE_ACH = 'ACH';
    /**
     * Constant for value 'Check'
     * @return string 'Check'
     */
    const VALUE_CHECK = 'Check';
    /**
     * Constant for value 'Cash'
     * @return string 'Cash'
     */
    const VALUE_CASH = 'Cash';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'InKind'
     * @return string 'InKind'
     */
    const VALUE_IN_KIND = 'InKind';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'ECheck'
     * @return string 'ECheck'
     */
    const VALUE_ECHECK = 'ECheck';
    /**
     * Constant for value 'PayPal'
     * @return string 'PayPal'
     */
    const VALUE_PAY_PAL = 'PayPal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_ACH
     * @uses self::VALUE_CHECK
     * @uses self::VALUE_CASH
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_IN_KIND
     * @uses self::VALUE_NONE
     * @uses self::VALUE_ECHECK
     * @uses self::VALUE_PAY_PAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CREDIT_CARD,
            self::VALUE_ACH,
            self::VALUE_CHECK,
            self::VALUE_CASH,
            self::VALUE_OTHER,
            self::VALUE_IN_KIND,
            self::VALUE_NONE,
            self::VALUE_ECHECK,
            self::VALUE_PAY_PAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
