<?php

namespace EnumType;

/**
 * This class stands for OptInListStatuses EnumType
 * @subpackage Enumerations
 */
class OptInListStatuses
{
    /**
     * Constant for value 'OptedIn'
     * @return string 'OptedIn'
     */
    const VALUE_OPTED_IN = 'OptedIn';
    /**
     * Constant for value 'OptedOut'
     * @return string 'OptedOut'
     */
    const VALUE_OPTED_OUT = 'OptedOut';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OPTED_IN
     * @uses self::VALUE_OPTED_OUT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OPTED_IN,
            self::VALUE_OPTED_OUT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
