<?php

namespace EnumType;

/**
 * This class stands for OptInListActions EnumType
 * @subpackage Enumerations
 */
class OptInListActions
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Add'
     * @return string 'Add'
     */
    const VALUE_ADD = 'Add';
    /**
     * Constant for value 'Remove'
     * @return string 'Remove'
     */
    const VALUE_REMOVE = 'Remove';
    /**
     * Constant for value 'OptIn'
     * @return string 'OptIn'
     */
    const VALUE_OPT_IN = 'OptIn';
    /**
     * Constant for value 'OptOut'
     * @return string 'OptOut'
     */
    const VALUE_OPT_OUT = 'OptOut';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_ADD
     * @uses self::VALUE_REMOVE
     * @uses self::VALUE_OPT_IN
     * @uses self::VALUE_OPT_OUT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_ADD,
            self::VALUE_REMOVE,
            self::VALUE_OPT_IN,
            self::VALUE_OPT_OUT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
