<?php

namespace EnumType;

/**
 * This class stands for NoteTypes EnumType
 * @subpackage Enumerations
 */
class NoteTypes
{
    /**
     * Constant for value 'Activity'
     * @return string 'Activity'
     */
    const VALUE_ACTIVITY = 'Activity';
    /**
     * Constant for value 'Advocacy'
     * @return string 'Advocacy'
     */
    const VALUE_ADVOCACY = 'Advocacy';
    /**
     * Constant for value 'Case'
     * @return string 'Case'
     */
    const VALUE_CASE = 'Case';
    /**
     * Constant for value 'Comment'
     * @return string 'Comment'
     */
    const VALUE_COMMENT = 'Comment';
    /**
     * Constant for value 'Contact'
     * @return string 'Contact'
     */
    const VALUE_CONTACT = 'Contact';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVITY
     * @uses self::VALUE_ADVOCACY
     * @uses self::VALUE_CASE
     * @uses self::VALUE_COMMENT
     * @uses self::VALUE_CONTACT
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVITY,
            self::VALUE_ADVOCACY,
            self::VALUE_CASE,
            self::VALUE_COMMENT,
            self::VALUE_CONTACT,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
