<?php

namespace EnumType;

/**
 * This class stands for InstantMessengerTypes EnumType
 * @subpackage Enumerations
 */
class InstantMessengerTypes
{
    /**
     * Constant for value 'AIM'
     * @return string 'AIM'
     */
    const VALUE_AIM = 'AIM';
    /**
     * Constant for value 'Google'
     * @return string 'Google'
     */
    const VALUE_GOOGLE = 'Google';
    /**
     * Constant for value 'ICQ'
     * @return string 'ICQ'
     */
    const VALUE_ICQ = 'ICQ';
    /**
     * Constant for value 'Skype'
     * @return string 'Skype'
     */
    const VALUE_SKYPE = 'Skype';
    /**
     * Constant for value 'WindowsLive'
     * @return string 'WindowsLive'
     */
    const VALUE_WINDOWS_LIVE = 'WindowsLive';
    /**
     * Constant for value 'Yahoo'
     * @return string 'Yahoo'
     */
    const VALUE_YAHOO = 'Yahoo';
    /**
     * Constant for value 'Jabber'
     * @return string 'Jabber'
     */
    const VALUE_JABBER = 'Jabber';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIM
     * @uses self::VALUE_GOOGLE
     * @uses self::VALUE_ICQ
     * @uses self::VALUE_SKYPE
     * @uses self::VALUE_WINDOWS_LIVE
     * @uses self::VALUE_YAHOO
     * @uses self::VALUE_JABBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIM,
            self::VALUE_GOOGLE,
            self::VALUE_ICQ,
            self::VALUE_SKYPE,
            self::VALUE_WINDOWS_LIVE,
            self::VALUE_YAHOO,
            self::VALUE_JABBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
