<?php

namespace EnumType;

/**
 * This class stands for InitiativeMessageReturnReasons EnumType
 * @subpackage Enumerations
 */
class InitiativeMessageReturnReasons
{
    /**
     * Constant for value 'Hard'
     * @return string 'Hard'
     */
    const VALUE_HARD = 'Hard';
    /**
     * Constant for value 'Soft'
     * @return string 'Soft'
     */
    const VALUE_SOFT = 'Soft';
    /**
     * Constant for value 'Challenge'
     * @return string 'Challenge'
     */
    const VALUE_CHALLENGE = 'Challenge';
    /**
     * Constant for value 'Spam'
     * @return string 'Spam'
     */
    const VALUE_SPAM = 'Spam';
    /**
     * Constant for value 'Virus'
     * @return string 'Virus'
     */
    const VALUE_VIRUS = 'Virus';
    /**
     * Constant for value 'BlockedOther'
     * @return string 'BlockedOther'
     */
    const VALUE_BLOCKED_OTHER = 'BlockedOther';
    /**
     * Constant for value 'Transient'
     * @return string 'Transient'
     */
    const VALUE_TRANSIENT = 'Transient';
    /**
     * Constant for value 'AutoReply'
     * @return string 'AutoReply'
     */
    const VALUE_AUTO_REPLY = 'AutoReply';
    /**
     * Constant for value 'Subscribe'
     * @return string 'Subscribe'
     */
    const VALUE_SUBSCRIBE = 'Subscribe';
    /**
     * Constant for value 'Unsubscribe'
     * @return string 'Unsubscribe'
     */
    const VALUE_UNSUBSCRIBE = 'Unsubscribe';
    /**
     * Constant for value 'AddressChange'
     * @return string 'AddressChange'
     */
    const VALUE_ADDRESS_CHANGE = 'AddressChange';
    /**
     * Constant for value 'Modified'
     * @return string 'Modified'
     */
    const VALUE_MODIFIED = 'Modified';
    /**
     * Constant for value 'Delivered'
     * @return string 'Delivered'
     */
    const VALUE_DELIVERED = 'Delivered';
    /**
     * Constant for value 'Custom'
     * @return string 'Custom'
     */
    const VALUE_CUSTOM = 'Custom';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HARD
     * @uses self::VALUE_SOFT
     * @uses self::VALUE_CHALLENGE
     * @uses self::VALUE_SPAM
     * @uses self::VALUE_VIRUS
     * @uses self::VALUE_BLOCKED_OTHER
     * @uses self::VALUE_TRANSIENT
     * @uses self::VALUE_AUTO_REPLY
     * @uses self::VALUE_SUBSCRIBE
     * @uses self::VALUE_UNSUBSCRIBE
     * @uses self::VALUE_ADDRESS_CHANGE
     * @uses self::VALUE_MODIFIED
     * @uses self::VALUE_DELIVERED
     * @uses self::VALUE_CUSTOM
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HARD,
            self::VALUE_SOFT,
            self::VALUE_CHALLENGE,
            self::VALUE_SPAM,
            self::VALUE_VIRUS,
            self::VALUE_BLOCKED_OTHER,
            self::VALUE_TRANSIENT,
            self::VALUE_AUTO_REPLY,
            self::VALUE_SUBSCRIBE,
            self::VALUE_UNSUBSCRIBE,
            self::VALUE_ADDRESS_CHANGE,
            self::VALUE_MODIFIED,
            self::VALUE_DELIVERED,
            self::VALUE_CUSTOM,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
