<?php

namespace EnumType;

/**
 * This class stands for InitiativeMessageDeliveryFailTypes EnumType
 * @subpackage Enumerations
 */
class InitiativeMessageDeliveryFailTypes
{
    /**
     * Constant for value 'Permanent'
     * @return string 'Permanent'
     */
    const VALUE_PERMANENT = 'Permanent';
    /**
     * Constant for value 'Temporary'
     * @return string 'Temporary'
     */
    const VALUE_TEMPORARY = 'Temporary';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PERMANENT
     * @uses self::VALUE_TEMPORARY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PERMANENT,
            self::VALUE_TEMPORARY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
