<?php

namespace EnumType;

/**
 * This class stands for InitiativeMessageDeliveryFailReasons EnumType
 * @subpackage Enumerations
 */
class InitiativeMessageDeliveryFailReasons
{
    /**
     * Constant for value 'DnsError'
     * @return string 'DnsError'
     */
    const VALUE_DNS_ERROR = 'DnsError';
    /**
     * Constant for value 'ConnectionError'
     * @return string 'ConnectionError'
     */
    const VALUE_CONNECTION_ERROR = 'ConnectionError';
    /**
     * Constant for value 'ResponseError'
     * @return string 'ResponseError'
     */
    const VALUE_RESPONSE_ERROR = 'ResponseError';
    /**
     * Constant for value 'SslAuthenticationError'
     * @return string 'SslAuthenticationError'
     */
    const VALUE_SSL_AUTHENTICATION_ERROR = 'SslAuthenticationError';
    /**
     * Constant for value 'MessageCreationError'
     * @return string 'MessageCreationError'
     */
    const VALUE_MESSAGE_CREATION_ERROR = 'MessageCreationError';
    /**
     * Constant for value 'BadDataError'
     * @return string 'BadDataError'
     */
    const VALUE_BAD_DATA_ERROR = 'BadDataError';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DNS_ERROR
     * @uses self::VALUE_CONNECTION_ERROR
     * @uses self::VALUE_RESPONSE_ERROR
     * @uses self::VALUE_SSL_AUTHENTICATION_ERROR
     * @uses self::VALUE_MESSAGE_CREATION_ERROR
     * @uses self::VALUE_BAD_DATA_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DNS_ERROR,
            self::VALUE_CONNECTION_ERROR,
            self::VALUE_RESPONSE_ERROR,
            self::VALUE_SSL_AUTHENTICATION_ERROR,
            self::VALUE_MESSAGE_CREATION_ERROR,
            self::VALUE_BAD_DATA_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
