<?php

namespace EnumType;

/**
 * This class stands for InitiativeAudienceMemberStatuses EnumType
 * @subpackage Enumerations
 */
class InitiativeAudienceMemberStatuses
{
    /**
     * Constant for value 'Validated'
     * @return string 'Validated'
     */
    const VALUE_VALIDATED = 'Validated';
    /**
     * Constant for value 'Duplicate'
     * @return string 'Duplicate'
     */
    const VALUE_DUPLICATE = 'Duplicate';
    /**
     * Constant for value 'KillFile'
     * @return string 'KillFile'
     */
    const VALUE_KILL_FILE = 'KillFile';
    /**
     * Constant for value 'Deceased'
     * @return string 'Deceased'
     */
    const VALUE_DECEASED = 'Deceased';
    /**
     * Constant for value 'OptedOut'
     * @return string 'OptedOut'
     */
    const VALUE_OPTED_OUT = 'OptedOut';
    /**
     * Constant for value 'Restricted'
     * @return string 'Restricted'
     */
    const VALUE_RESTRICTED = 'Restricted';
    /**
     * Constant for value 'Suppressed'
     * @return string 'Suppressed'
     */
    const VALUE_SUPPRESSED = 'Suppressed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VALIDATED
     * @uses self::VALUE_DUPLICATE
     * @uses self::VALUE_KILL_FILE
     * @uses self::VALUE_DECEASED
     * @uses self::VALUE_OPTED_OUT
     * @uses self::VALUE_RESTRICTED
     * @uses self::VALUE_SUPPRESSED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VALIDATED,
            self::VALUE_DUPLICATE,
            self::VALUE_KILL_FILE,
            self::VALUE_DECEASED,
            self::VALUE_OPTED_OUT,
            self::VALUE_RESTRICTED,
            self::VALUE_SUPPRESSED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
