<?php

namespace EnumType;

/**
 * This class stands for ECheckTypes EnumType
 * @subpackage Enumerations
 */
class ECheckTypes
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'ARC'
     * @return string 'ARC'
     */
    const VALUE_ARC = 'ARC';
    /**
     * Constant for value 'BOC'
     * @return string 'BOC'
     */
    const VALUE_BOC = 'BOC';
    /**
     * Constant for value 'WEB'
     * @return string 'WEB'
     */
    const VALUE_WEB = 'WEB';
    /**
     * Constant for value 'TEL'
     * @return string 'TEL'
     */
    const VALUE_TEL = 'TEL';
    /**
     * Constant for value 'CCD'
     * @return string 'CCD'
     */
    const VALUE_CCD = 'CCD';
    /**
     * Constant for value 'PPD'
     * @return string 'PPD'
     */
    const VALUE_PPD = 'PPD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_ARC
     * @uses self::VALUE_BOC
     * @uses self::VALUE_WEB
     * @uses self::VALUE_TEL
     * @uses self::VALUE_CCD
     * @uses self::VALUE_PPD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_ARC,
            self::VALUE_BOC,
            self::VALUE_WEB,
            self::VALUE_TEL,
            self::VALUE_CCD,
            self::VALUE_PPD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
