<?php

namespace EnumType;

/**
 * This class stands for CreateSustainerModes EnumType
 * @subpackage Enumerations
 */
class CreateSustainerModes
{
    /**
     * Constant for value 'AlwaysCreate'
     * @return string 'AlwaysCreate'
     */
    const VALUE_ALWAYS_CREATE = 'AlwaysCreate';
    /**
     * Constant for value 'RequireValidFormOfPayment'
     * @return string 'RequireValidFormOfPayment'
     */
    const VALUE_REQUIRE_VALID_FORM_OF_PAYMENT = 'RequireValidFormOfPayment';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALWAYS_CREATE
     * @uses self::VALUE_REQUIRE_VALID_FORM_OF_PAYMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALWAYS_CREATE,
            self::VALUE_REQUIRE_VALID_FORM_OF_PAYMENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
