<?php

namespace EnumType;

/**
 * This class stands for ContactInfoCopyModes EnumType
 * @subpackage Enumerations
 */
class ContactInfoCopyModes
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'OverwritePrimary'
     * @return string 'OverwritePrimary'
     */
    const VALUE_OVERWRITE_PRIMARY = 'OverwritePrimary';
    /**
     * Constant for value 'AddPrimary'
     * @return string 'AddPrimary'
     */
    const VALUE_ADD_PRIMARY = 'AddPrimary';
    /**
     * Constant for value 'AddSecondary'
     * @return string 'AddSecondary'
     */
    const VALUE_ADD_SECONDARY = 'AddSecondary';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_OVERWRITE_PRIMARY
     * @uses self::VALUE_ADD_PRIMARY
     * @uses self::VALUE_ADD_SECONDARY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_OVERWRITE_PRIMARY,
            self::VALUE_ADD_PRIMARY,
            self::VALUE_ADD_SECONDARY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
