<?php

namespace EnumType;

/**
 * This class stands for AuthenticationTypes EnumType
 * @subpackage Enumerations
 */
class AuthenticationTypes
{
    /**
     * Constant for value 'WebServiceUser'
     * @return string 'WebServiceUser'
     */
    const VALUE_WEB_SERVICE_USER = 'WebServiceUser';
    /**
     * Constant for value 'CharityEngineAdminUser'
     * @return string 'CharityEngineAdminUser'
     */
    const VALUE_CHARITY_ENGINE_ADMIN_USER = 'CharityEngineAdminUser';
    /**
     * Constant for value 'Contact'
     * @return string 'Contact'
     */
    const VALUE_CONTACT = 'Contact';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WEB_SERVICE_USER
     * @uses self::VALUE_CHARITY_ENGINE_ADMIN_USER
     * @uses self::VALUE_CONTACT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WEB_SERVICE_USER,
            self::VALUE_CHARITY_ENGINE_ADMIN_USER,
            self::VALUE_CONTACT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
