<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWebsiteRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfWebsiteRecord extends AbstractStructArrayBase
{
    /**
     * The WebsiteRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WebsiteRecord[]
     */
    public $WebsiteRecord;
    /**
     * Constructor method for ArrayOfWebsiteRecord
     * @uses ArrayOfWebsiteRecord::setWebsiteRecord()
     * @param \StructType\WebsiteRecord[] $websiteRecord
     */
    public function __construct(array $websiteRecord = array())
    {
        $this
            ->setWebsiteRecord($websiteRecord);
    }
    /**
     * Get WebsiteRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WebsiteRecord[]|null
     */
    public function getWebsiteRecord()
    {
        return isset($this->WebsiteRecord) ? $this->WebsiteRecord : null;
    }
    /**
     * Set WebsiteRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WebsiteRecord[] $websiteRecord
     * @return \ArrayType\ArrayOfWebsiteRecord
     */
    public function setWebsiteRecord(array $websiteRecord = array())
    {
        foreach ($websiteRecord as $arrayOfWebsiteRecordWebsiteRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfWebsiteRecordWebsiteRecordItem instanceof \StructType\WebsiteRecord) {
                throw new \InvalidArgumentException(sprintf('The WebsiteRecord property can only contain items of \StructType\WebsiteRecord, "%s" given', is_object($arrayOfWebsiteRecordWebsiteRecordItem) ? get_class($arrayOfWebsiteRecordWebsiteRecordItem) : gettype($arrayOfWebsiteRecordWebsiteRecordItem)), __LINE__);
            }
        }
        if (is_null($websiteRecord) || (is_array($websiteRecord) && empty($websiteRecord))) {
            unset($this->WebsiteRecord);
        } else {
            $this->WebsiteRecord = $websiteRecord;
        }
        return $this;
    }
    /**
     * Add item to WebsiteRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\WebsiteRecord $item
     * @return \ArrayType\ArrayOfWebsiteRecord
     */
    public function addToWebsiteRecord(\StructType\WebsiteRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WebsiteRecord) {
            throw new \InvalidArgumentException(sprintf('The WebsiteRecord property can only contain items of \StructType\WebsiteRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WebsiteRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WebsiteRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WebsiteRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WebsiteRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WebsiteRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WebsiteRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WebsiteRecord
     */
    public function getAttributeName()
    {
        return 'WebsiteRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfWebsiteRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
