<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWebFormRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfWebFormRecord extends AbstractStructArrayBase
{
    /**
     * The WebFormRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WebFormRecord[]
     */
    public $WebFormRecord;
    /**
     * Constructor method for ArrayOfWebFormRecord
     * @uses ArrayOfWebFormRecord::setWebFormRecord()
     * @param \StructType\WebFormRecord[] $webFormRecord
     */
    public function __construct(array $webFormRecord = array())
    {
        $this
            ->setWebFormRecord($webFormRecord);
    }
    /**
     * Get WebFormRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WebFormRecord[]|null
     */
    public function getWebFormRecord()
    {
        return isset($this->WebFormRecord) ? $this->WebFormRecord : null;
    }
    /**
     * Set WebFormRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WebFormRecord[] $webFormRecord
     * @return \ArrayType\ArrayOfWebFormRecord
     */
    public function setWebFormRecord(array $webFormRecord = array())
    {
        foreach ($webFormRecord as $arrayOfWebFormRecordWebFormRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfWebFormRecordWebFormRecordItem instanceof \StructType\WebFormRecord) {
                throw new \InvalidArgumentException(sprintf('The WebFormRecord property can only contain items of \StructType\WebFormRecord, "%s" given', is_object($arrayOfWebFormRecordWebFormRecordItem) ? get_class($arrayOfWebFormRecordWebFormRecordItem) : gettype($arrayOfWebFormRecordWebFormRecordItem)), __LINE__);
            }
        }
        if (is_null($webFormRecord) || (is_array($webFormRecord) && empty($webFormRecord))) {
            unset($this->WebFormRecord);
        } else {
            $this->WebFormRecord = $webFormRecord;
        }
        return $this;
    }
    /**
     * Add item to WebFormRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\WebFormRecord $item
     * @return \ArrayType\ArrayOfWebFormRecord
     */
    public function addToWebFormRecord(\StructType\WebFormRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WebFormRecord) {
            throw new \InvalidArgumentException(sprintf('The WebFormRecord property can only contain items of \StructType\WebFormRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WebFormRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WebFormRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WebFormRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WebFormRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WebFormRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WebFormRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WebFormRecord
     */
    public function getAttributeName()
    {
        return 'WebFormRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfWebFormRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
