<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransactionRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfTransactionRecord extends AbstractStructArrayBase
{
    /**
     * The TransactionRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TransactionRecord[]
     */
    public $TransactionRecord;
    /**
     * Constructor method for ArrayOfTransactionRecord
     * @uses ArrayOfTransactionRecord::setTransactionRecord()
     * @param \StructType\TransactionRecord[] $transactionRecord
     */
    public function __construct(array $transactionRecord = array())
    {
        $this
            ->setTransactionRecord($transactionRecord);
    }
    /**
     * Get TransactionRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TransactionRecord[]|null
     */
    public function getTransactionRecord()
    {
        return isset($this->TransactionRecord) ? $this->TransactionRecord : null;
    }
    /**
     * Set TransactionRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionRecord[] $transactionRecord
     * @return \ArrayType\ArrayOfTransactionRecord
     */
    public function setTransactionRecord(array $transactionRecord = array())
    {
        foreach ($transactionRecord as $arrayOfTransactionRecordTransactionRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransactionRecordTransactionRecordItem instanceof \StructType\TransactionRecord) {
                throw new \InvalidArgumentException(sprintf('The TransactionRecord property can only contain items of \StructType\TransactionRecord, "%s" given', is_object($arrayOfTransactionRecordTransactionRecordItem) ? get_class($arrayOfTransactionRecordTransactionRecordItem) : gettype($arrayOfTransactionRecordTransactionRecordItem)), __LINE__);
            }
        }
        if (is_null($transactionRecord) || (is_array($transactionRecord) && empty($transactionRecord))) {
            unset($this->TransactionRecord);
        } else {
            $this->TransactionRecord = $transactionRecord;
        }
        return $this;
    }
    /**
     * Add item to TransactionRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionRecord $item
     * @return \ArrayType\ArrayOfTransactionRecord
     */
    public function addToTransactionRecord(\StructType\TransactionRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransactionRecord) {
            throw new \InvalidArgumentException(sprintf('The TransactionRecord property can only contain items of \StructType\TransactionRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TransactionRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TransactionRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TransactionRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TransactionRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TransactionRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TransactionRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransactionRecord
     */
    public function getAttributeName()
    {
        return 'TransactionRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTransactionRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
