<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSettleCreditCardParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfSettleCreditCardParameters extends AbstractStructArrayBase
{
    /**
     * The SettleCreditCardParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SettleCreditCardParameters[]
     */
    public $SettleCreditCardParameters;
    /**
     * Constructor method for ArrayOfSettleCreditCardParameters
     * @uses ArrayOfSettleCreditCardParameters::setSettleCreditCardParameters()
     * @param \StructType\SettleCreditCardParameters[] $settleCreditCardParameters
     */
    public function __construct(array $settleCreditCardParameters = array())
    {
        $this
            ->setSettleCreditCardParameters($settleCreditCardParameters);
    }
    /**
     * Get SettleCreditCardParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SettleCreditCardParameters[]|null
     */
    public function getSettleCreditCardParameters()
    {
        return isset($this->SettleCreditCardParameters) ? $this->SettleCreditCardParameters : null;
    }
    /**
     * Set SettleCreditCardParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SettleCreditCardParameters[] $settleCreditCardParameters
     * @return \ArrayType\ArrayOfSettleCreditCardParameters
     */
    public function setSettleCreditCardParameters(array $settleCreditCardParameters = array())
    {
        foreach ($settleCreditCardParameters as $arrayOfSettleCreditCardParametersSettleCreditCardParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfSettleCreditCardParametersSettleCreditCardParametersItem instanceof \StructType\SettleCreditCardParameters) {
                throw new \InvalidArgumentException(sprintf('The SettleCreditCardParameters property can only contain items of \StructType\SettleCreditCardParameters, "%s" given', is_object($arrayOfSettleCreditCardParametersSettleCreditCardParametersItem) ? get_class($arrayOfSettleCreditCardParametersSettleCreditCardParametersItem) : gettype($arrayOfSettleCreditCardParametersSettleCreditCardParametersItem)), __LINE__);
            }
        }
        if (is_null($settleCreditCardParameters) || (is_array($settleCreditCardParameters) && empty($settleCreditCardParameters))) {
            unset($this->SettleCreditCardParameters);
        } else {
            $this->SettleCreditCardParameters = $settleCreditCardParameters;
        }
        return $this;
    }
    /**
     * Add item to SettleCreditCardParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\SettleCreditCardParameters $item
     * @return \ArrayType\ArrayOfSettleCreditCardParameters
     */
    public function addToSettleCreditCardParameters(\StructType\SettleCreditCardParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SettleCreditCardParameters) {
            throw new \InvalidArgumentException(sprintf('The SettleCreditCardParameters property can only contain items of \StructType\SettleCreditCardParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SettleCreditCardParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SettleCreditCardParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SettleCreditCardParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SettleCreditCardParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SettleCreditCardParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SettleCreditCardParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SettleCreditCardParameters
     */
    public function getAttributeName()
    {
        return 'SettleCreditCardParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSettleCreditCardParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
