<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRefundElectronicPaymentParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfRefundElectronicPaymentParameters extends AbstractStructArrayBase
{
    /**
     * The RefundElectronicPaymentParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RefundElectronicPaymentParameters[]
     */
    public $RefundElectronicPaymentParameters;
    /**
     * Constructor method for ArrayOfRefundElectronicPaymentParameters
     * @uses ArrayOfRefundElectronicPaymentParameters::setRefundElectronicPaymentParameters()
     * @param \StructType\RefundElectronicPaymentParameters[] $refundElectronicPaymentParameters
     */
    public function __construct(array $refundElectronicPaymentParameters = array())
    {
        $this
            ->setRefundElectronicPaymentParameters($refundElectronicPaymentParameters);
    }
    /**
     * Get RefundElectronicPaymentParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RefundElectronicPaymentParameters[]|null
     */
    public function getRefundElectronicPaymentParameters()
    {
        return isset($this->RefundElectronicPaymentParameters) ? $this->RefundElectronicPaymentParameters : null;
    }
    /**
     * Set RefundElectronicPaymentParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RefundElectronicPaymentParameters[] $refundElectronicPaymentParameters
     * @return \ArrayType\ArrayOfRefundElectronicPaymentParameters
     */
    public function setRefundElectronicPaymentParameters(array $refundElectronicPaymentParameters = array())
    {
        foreach ($refundElectronicPaymentParameters as $arrayOfRefundElectronicPaymentParametersRefundElectronicPaymentParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfRefundElectronicPaymentParametersRefundElectronicPaymentParametersItem instanceof \StructType\RefundElectronicPaymentParameters) {
                throw new \InvalidArgumentException(sprintf('The RefundElectronicPaymentParameters property can only contain items of \StructType\RefundElectronicPaymentParameters, "%s" given', is_object($arrayOfRefundElectronicPaymentParametersRefundElectronicPaymentParametersItem) ? get_class($arrayOfRefundElectronicPaymentParametersRefundElectronicPaymentParametersItem) : gettype($arrayOfRefundElectronicPaymentParametersRefundElectronicPaymentParametersItem)), __LINE__);
            }
        }
        if (is_null($refundElectronicPaymentParameters) || (is_array($refundElectronicPaymentParameters) && empty($refundElectronicPaymentParameters))) {
            unset($this->RefundElectronicPaymentParameters);
        } else {
            $this->RefundElectronicPaymentParameters = $refundElectronicPaymentParameters;
        }
        return $this;
    }
    /**
     * Add item to RefundElectronicPaymentParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\RefundElectronicPaymentParameters $item
     * @return \ArrayType\ArrayOfRefundElectronicPaymentParameters
     */
    public function addToRefundElectronicPaymentParameters(\StructType\RefundElectronicPaymentParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RefundElectronicPaymentParameters) {
            throw new \InvalidArgumentException(sprintf('The RefundElectronicPaymentParameters property can only contain items of \StructType\RefundElectronicPaymentParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RefundElectronicPaymentParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RefundElectronicPaymentParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RefundElectronicPaymentParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RefundElectronicPaymentParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RefundElectronicPaymentParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RefundElectronicPaymentParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RefundElectronicPaymentParameters
     */
    public function getAttributeName()
    {
        return 'RefundElectronicPaymentParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRefundElectronicPaymentParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
