<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProcessPaymentResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfProcessPaymentResponse extends AbstractStructArrayBase
{
    /**
     * The ProcessPaymentResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProcessPaymentResponse[]
     */
    public $ProcessPaymentResponse;
    /**
     * Constructor method for ArrayOfProcessPaymentResponse
     * @uses ArrayOfProcessPaymentResponse::setProcessPaymentResponse()
     * @param \StructType\ProcessPaymentResponse[] $processPaymentResponse
     */
    public function __construct(array $processPaymentResponse = array())
    {
        $this
            ->setProcessPaymentResponse($processPaymentResponse);
    }
    /**
     * Get ProcessPaymentResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProcessPaymentResponse[]|null
     */
    public function getProcessPaymentResponse()
    {
        return isset($this->ProcessPaymentResponse) ? $this->ProcessPaymentResponse : null;
    }
    /**
     * Set ProcessPaymentResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProcessPaymentResponse[] $processPaymentResponse
     * @return \ArrayType\ArrayOfProcessPaymentResponse
     */
    public function setProcessPaymentResponse(array $processPaymentResponse = array())
    {
        foreach ($processPaymentResponse as $arrayOfProcessPaymentResponseProcessPaymentResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfProcessPaymentResponseProcessPaymentResponseItem instanceof \StructType\ProcessPaymentResponse) {
                throw new \InvalidArgumentException(sprintf('The ProcessPaymentResponse property can only contain items of \StructType\ProcessPaymentResponse, "%s" given', is_object($arrayOfProcessPaymentResponseProcessPaymentResponseItem) ? get_class($arrayOfProcessPaymentResponseProcessPaymentResponseItem) : gettype($arrayOfProcessPaymentResponseProcessPaymentResponseItem)), __LINE__);
            }
        }
        if (is_null($processPaymentResponse) || (is_array($processPaymentResponse) && empty($processPaymentResponse))) {
            unset($this->ProcessPaymentResponse);
        } else {
            $this->ProcessPaymentResponse = $processPaymentResponse;
        }
        return $this;
    }
    /**
     * Add item to ProcessPaymentResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ProcessPaymentResponse $item
     * @return \ArrayType\ArrayOfProcessPaymentResponse
     */
    public function addToProcessPaymentResponse(\StructType\ProcessPaymentResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProcessPaymentResponse) {
            throw new \InvalidArgumentException(sprintf('The ProcessPaymentResponse property can only contain items of \StructType\ProcessPaymentResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProcessPaymentResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProcessPaymentResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProcessPaymentResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProcessPaymentResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProcessPaymentResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProcessPaymentResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProcessPaymentResponse
     */
    public function getAttributeName()
    {
        return 'ProcessPaymentResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProcessPaymentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
