<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPledgeRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfPledgeRecord extends AbstractStructArrayBase
{
    /**
     * The PledgeRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PledgeRecord[]
     */
    public $PledgeRecord;
    /**
     * Constructor method for ArrayOfPledgeRecord
     * @uses ArrayOfPledgeRecord::setPledgeRecord()
     * @param \StructType\PledgeRecord[] $pledgeRecord
     */
    public function __construct(array $pledgeRecord = array())
    {
        $this
            ->setPledgeRecord($pledgeRecord);
    }
    /**
     * Get PledgeRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PledgeRecord[]|null
     */
    public function getPledgeRecord()
    {
        return isset($this->PledgeRecord) ? $this->PledgeRecord : null;
    }
    /**
     * Set PledgeRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PledgeRecord[] $pledgeRecord
     * @return \ArrayType\ArrayOfPledgeRecord
     */
    public function setPledgeRecord(array $pledgeRecord = array())
    {
        foreach ($pledgeRecord as $arrayOfPledgeRecordPledgeRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfPledgeRecordPledgeRecordItem instanceof \StructType\PledgeRecord) {
                throw new \InvalidArgumentException(sprintf('The PledgeRecord property can only contain items of \StructType\PledgeRecord, "%s" given', is_object($arrayOfPledgeRecordPledgeRecordItem) ? get_class($arrayOfPledgeRecordPledgeRecordItem) : gettype($arrayOfPledgeRecordPledgeRecordItem)), __LINE__);
            }
        }
        if (is_null($pledgeRecord) || (is_array($pledgeRecord) && empty($pledgeRecord))) {
            unset($this->PledgeRecord);
        } else {
            $this->PledgeRecord = $pledgeRecord;
        }
        return $this;
    }
    /**
     * Add item to PledgeRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\PledgeRecord $item
     * @return \ArrayType\ArrayOfPledgeRecord
     */
    public function addToPledgeRecord(\StructType\PledgeRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PledgeRecord) {
            throw new \InvalidArgumentException(sprintf('The PledgeRecord property can only contain items of \StructType\PledgeRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PledgeRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PledgeRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PledgeRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PledgeRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PledgeRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PledgeRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PledgeRecord
     */
    public function getAttributeName()
    {
        return 'PledgeRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPledgeRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
