<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPhoneNumberRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfPhoneNumberRecord extends AbstractStructArrayBase
{
    /**
     * The PhoneNumberRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PhoneNumberRecord[]
     */
    public $PhoneNumberRecord;
    /**
     * Constructor method for ArrayOfPhoneNumberRecord
     * @uses ArrayOfPhoneNumberRecord::setPhoneNumberRecord()
     * @param \StructType\PhoneNumberRecord[] $phoneNumberRecord
     */
    public function __construct(array $phoneNumberRecord = array())
    {
        $this
            ->setPhoneNumberRecord($phoneNumberRecord);
    }
    /**
     * Get PhoneNumberRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PhoneNumberRecord[]|null
     */
    public function getPhoneNumberRecord()
    {
        return isset($this->PhoneNumberRecord) ? $this->PhoneNumberRecord : null;
    }
    /**
     * Set PhoneNumberRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneNumberRecord[] $phoneNumberRecord
     * @return \ArrayType\ArrayOfPhoneNumberRecord
     */
    public function setPhoneNumberRecord(array $phoneNumberRecord = array())
    {
        foreach ($phoneNumberRecord as $arrayOfPhoneNumberRecordPhoneNumberRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfPhoneNumberRecordPhoneNumberRecordItem instanceof \StructType\PhoneNumberRecord) {
                throw new \InvalidArgumentException(sprintf('The PhoneNumberRecord property can only contain items of \StructType\PhoneNumberRecord, "%s" given', is_object($arrayOfPhoneNumberRecordPhoneNumberRecordItem) ? get_class($arrayOfPhoneNumberRecordPhoneNumberRecordItem) : gettype($arrayOfPhoneNumberRecordPhoneNumberRecordItem)), __LINE__);
            }
        }
        if (is_null($phoneNumberRecord) || (is_array($phoneNumberRecord) && empty($phoneNumberRecord))) {
            unset($this->PhoneNumberRecord);
        } else {
            $this->PhoneNumberRecord = $phoneNumberRecord;
        }
        return $this;
    }
    /**
     * Add item to PhoneNumberRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneNumberRecord $item
     * @return \ArrayType\ArrayOfPhoneNumberRecord
     */
    public function addToPhoneNumberRecord(\StructType\PhoneNumberRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhoneNumberRecord) {
            throw new \InvalidArgumentException(sprintf('The PhoneNumberRecord property can only contain items of \StructType\PhoneNumberRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PhoneNumberRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PhoneNumberRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PhoneNumberRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PhoneNumberRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PhoneNumberRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PhoneNumberRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PhoneNumberRecord
     */
    public function getAttributeName()
    {
        return 'PhoneNumberRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPhoneNumberRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
