<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOptInListRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfOptInListRecord extends AbstractStructArrayBase
{
    /**
     * The OptInListRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OptInListRecord[]
     */
    public $OptInListRecord;
    /**
     * Constructor method for ArrayOfOptInListRecord
     * @uses ArrayOfOptInListRecord::setOptInListRecord()
     * @param \StructType\OptInListRecord[] $optInListRecord
     */
    public function __construct(array $optInListRecord = array())
    {
        $this
            ->setOptInListRecord($optInListRecord);
    }
    /**
     * Get OptInListRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OptInListRecord[]|null
     */
    public function getOptInListRecord()
    {
        return isset($this->OptInListRecord) ? $this->OptInListRecord : null;
    }
    /**
     * Set OptInListRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OptInListRecord[] $optInListRecord
     * @return \ArrayType\ArrayOfOptInListRecord
     */
    public function setOptInListRecord(array $optInListRecord = array())
    {
        foreach ($optInListRecord as $arrayOfOptInListRecordOptInListRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfOptInListRecordOptInListRecordItem instanceof \StructType\OptInListRecord) {
                throw new \InvalidArgumentException(sprintf('The OptInListRecord property can only contain items of \StructType\OptInListRecord, "%s" given', is_object($arrayOfOptInListRecordOptInListRecordItem) ? get_class($arrayOfOptInListRecordOptInListRecordItem) : gettype($arrayOfOptInListRecordOptInListRecordItem)), __LINE__);
            }
        }
        if (is_null($optInListRecord) || (is_array($optInListRecord) && empty($optInListRecord))) {
            unset($this->OptInListRecord);
        } else {
            $this->OptInListRecord = $optInListRecord;
        }
        return $this;
    }
    /**
     * Add item to OptInListRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\OptInListRecord $item
     * @return \ArrayType\ArrayOfOptInListRecord
     */
    public function addToOptInListRecord(\StructType\OptInListRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OptInListRecord) {
            throw new \InvalidArgumentException(sprintf('The OptInListRecord property can only contain items of \StructType\OptInListRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OptInListRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OptInListRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OptInListRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OptInListRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OptInListRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OptInListRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OptInListRecord
     */
    public function getAttributeName()
    {
        return 'OptInListRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOptInListRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
