<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOpportunityRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfOpportunityRecord extends AbstractStructArrayBase
{
    /**
     * The OpportunityRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OpportunityRecord[]
     */
    public $OpportunityRecord;
    /**
     * Constructor method for ArrayOfOpportunityRecord
     * @uses ArrayOfOpportunityRecord::setOpportunityRecord()
     * @param \StructType\OpportunityRecord[] $opportunityRecord
     */
    public function __construct(array $opportunityRecord = array())
    {
        $this
            ->setOpportunityRecord($opportunityRecord);
    }
    /**
     * Get OpportunityRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OpportunityRecord[]|null
     */
    public function getOpportunityRecord()
    {
        return isset($this->OpportunityRecord) ? $this->OpportunityRecord : null;
    }
    /**
     * Set OpportunityRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OpportunityRecord[] $opportunityRecord
     * @return \ArrayType\ArrayOfOpportunityRecord
     */
    public function setOpportunityRecord(array $opportunityRecord = array())
    {
        foreach ($opportunityRecord as $arrayOfOpportunityRecordOpportunityRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfOpportunityRecordOpportunityRecordItem instanceof \StructType\OpportunityRecord) {
                throw new \InvalidArgumentException(sprintf('The OpportunityRecord property can only contain items of \StructType\OpportunityRecord, "%s" given', is_object($arrayOfOpportunityRecordOpportunityRecordItem) ? get_class($arrayOfOpportunityRecordOpportunityRecordItem) : gettype($arrayOfOpportunityRecordOpportunityRecordItem)), __LINE__);
            }
        }
        if (is_null($opportunityRecord) || (is_array($opportunityRecord) && empty($opportunityRecord))) {
            unset($this->OpportunityRecord);
        } else {
            $this->OpportunityRecord = $opportunityRecord;
        }
        return $this;
    }
    /**
     * Add item to OpportunityRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\OpportunityRecord $item
     * @return \ArrayType\ArrayOfOpportunityRecord
     */
    public function addToOpportunityRecord(\StructType\OpportunityRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OpportunityRecord) {
            throw new \InvalidArgumentException(sprintf('The OpportunityRecord property can only contain items of \StructType\OpportunityRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OpportunityRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OpportunityRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OpportunityRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OpportunityRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OpportunityRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OpportunityRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OpportunityRecord
     */
    public function getAttributeName()
    {
        return 'OpportunityRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOpportunityRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
