<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInitiativeRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfInitiativeRecord extends AbstractStructArrayBase
{
    /**
     * The InitiativeRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InitiativeRecord[]
     */
    public $InitiativeRecord;
    /**
     * Constructor method for ArrayOfInitiativeRecord
     * @uses ArrayOfInitiativeRecord::setInitiativeRecord()
     * @param \StructType\InitiativeRecord[] $initiativeRecord
     */
    public function __construct(array $initiativeRecord = array())
    {
        $this
            ->setInitiativeRecord($initiativeRecord);
    }
    /**
     * Get InitiativeRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InitiativeRecord[]|null
     */
    public function getInitiativeRecord()
    {
        return isset($this->InitiativeRecord) ? $this->InitiativeRecord : null;
    }
    /**
     * Set InitiativeRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InitiativeRecord[] $initiativeRecord
     * @return \ArrayType\ArrayOfInitiativeRecord
     */
    public function setInitiativeRecord(array $initiativeRecord = array())
    {
        foreach ($initiativeRecord as $arrayOfInitiativeRecordInitiativeRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfInitiativeRecordInitiativeRecordItem instanceof \StructType\InitiativeRecord) {
                throw new \InvalidArgumentException(sprintf('The InitiativeRecord property can only contain items of \StructType\InitiativeRecord, "%s" given', is_object($arrayOfInitiativeRecordInitiativeRecordItem) ? get_class($arrayOfInitiativeRecordInitiativeRecordItem) : gettype($arrayOfInitiativeRecordInitiativeRecordItem)), __LINE__);
            }
        }
        if (is_null($initiativeRecord) || (is_array($initiativeRecord) && empty($initiativeRecord))) {
            unset($this->InitiativeRecord);
        } else {
            $this->InitiativeRecord = $initiativeRecord;
        }
        return $this;
    }
    /**
     * Add item to InitiativeRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\InitiativeRecord $item
     * @return \ArrayType\ArrayOfInitiativeRecord
     */
    public function addToInitiativeRecord(\StructType\InitiativeRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InitiativeRecord) {
            throw new \InvalidArgumentException(sprintf('The InitiativeRecord property can only contain items of \StructType\InitiativeRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InitiativeRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InitiativeRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InitiativeRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InitiativeRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InitiativeRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InitiativeRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InitiativeRecord
     */
    public function getAttributeName()
    {
        return 'InitiativeRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfInitiativeRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
